/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.internal.core;

import com.nxp.s32ds.cle.uct.core.ISDKProjectHandler;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.internal.core.SDKProjectHandler;
import com.nxp.s32ds.cle.uct.internal.core.ToolchainSettingsUtils;
import com.nxp.s32ds.cle.uct.internal.core.UctEclipseProjectAdapterParams;
import com.nxp.s32ds.cle.uct.internal.core.UctSdkComponentInProjectDetector;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.scripting.ToolchainScriptProfile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptProfile;
import com.nxp.swtools.periphs.model.resources.ProcessorFilterForPeripherals;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.IStorageConfigurationPreferencesRead;
import com.nxp.swtools.provider.toolchainproject.EclipseProjectAdapterParams;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.sdkproject.EclipseProjectAdapter;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.ToolchainProjectUtils;
import com.nxp.swtools.utils.scripting.CodeGenerator;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.scripting.api.IProfileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptFileProvider;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.script.CompiledScript;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;

public class S32DSProjectAdapter
extends EclipseProjectAdapter {
    private ISDKProjectHandler prjHandler;
    private static final String TOOLCHAIN_SETTINGS_JS_FILENAME = "toolchain_settings.js";

    public S32DSProjectAdapter(EclipseProjectAdapterParams params) {
        super(params);
        Map<String, String> context = null;
        if (params instanceof UctEclipseProjectAdapterParams) {
            context = ((UctEclipseProjectAdapterParams)params).getContext();
        }
        this.prjHandler = new SDKProjectHandler(this.eclipsePrj, context);
    }

    public String getToolchainId() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.prjHandler.getToolchainId();
    }

    public String getToolchain() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.prjHandler.getToolchain();
    }

    public String getProcessor() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.prjHandler.getProcessor();
    }

    public String getPartNumber() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.prjHandler.getPartNumber();
    }

    public String getCoreId() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        String id = this.prjHandler.getCoreId();
        if (id == null && (id = super.getCoreId()) == null) {
            id = this.prjHandler.getCoreId(ToolchainProjectUtils.getCoresFromYaml((IToolchainProjectWithSdk)this));
        }
        return id;
    }

    public String getSdkVersion() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.prjHandler.getSDKId();
    }

    public String getSdkName() {
        if (!this.isProjectAccessible()) {
            return null;
        }
        return this.prjHandler.getSDKName();
    }

    public List<Path> getIncludePaths() {
        return Collections.emptyList();
    }

    public boolean canAddAdditionalComponents() {
        return this.wasProjectDetected() && this.isProjectAccessible();
    }

    public void updateProjectSettings(ISharedConfiguration sharedConfig, Collection<String> updatedFiles) {
        try {
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription des = mngr.createProjectDescription(this.eclipsePrj, true);
            ToolchainSettingsUtils.clearAllPreviousSettings(des);
            String previousComponents = ProjectPropertiesManager.getOneEntry(des, "COND_TOOLCHAIN_COMPONENTS_OPTION", "com.nxp.s32ds.cle.uct.internal.core.toolchainScriptProfile");
            ToolchainSettingsUtils.clearConditionalComponents(des, "com.nxp.s32ds.cle.uct.internal.core.toolchainScriptProfile", this.prjHandler);
            CoreModel.getDefault().setProjectDescription(this.eclipsePrj, des);
            Controller controller = Controller.getInstance();
            ScriptResult periphGenCode = controller.getGeneratedCode();
            if (periphGenCode != null && !periphGenCode.containsAnyError()) {
                CompiledScript compiledScript;
                ConfigurationComponentTypeId systemComponent = S32DSProjectAdapter.getSystemComponent(controller.getProfile().getActiveComponents().getConfigCompTypeIds(), sharedConfig.getCommonConfig().getMcuIdentification());
                String[] scriptFileFolders = systemComponent != null ? S32DSProjectAdapter.getScriptFileFolders(systemComponent, (IMcuIdentification)sharedConfig.getCommonConfig()) : new String[]{};
                CompiledScript compiledScript2 = compiledScript = systemComponent != null ? S32DSProjectAdapter.compileCodeGenerator(systemComponent, (IMcuIdentification)sharedConfig.getCommonConfig()) : null;
                if (compiledScript != null) {
                    ScriptFileProvider scriptFileProvider;
                    final ToolchainScriptProfile toolchainScriptProfile = new ToolchainScriptProfile(controller.getMcu(), controller.getProfile(), des);
                    IProfileProvider profileProvider = new IProfileProvider(){

                        public PeripheralsScriptProfile getProfile(Thread uiThread) {
                            return toolchainScriptProfile;
                        }
                    };
                    ScriptResult generatedCode = new CodeGenerator(profileProvider, (IScriptFileProvider)(scriptFileProvider = new ScriptFileProvider(scriptFileFolders)), (IStorageConfigurationPreferencesRead)SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences()).generate(compiledScript);
                    if (!generatedCode.containsAnyError()) {
                        toolchainScriptProfile.applyDependencies();
                    }
                    toolchainScriptProfile.saveToolchainComponents();
                    CoreModel.getDefault().setProjectDescription(this.eclipsePrj, des);
                }
                ToolchainSettingsUtils.addRemoveConditionalComponents(this.eclipsePrj, "com.nxp.s32ds.cle.uct.internal.core.toolchainScriptProfile", this.prjHandler, previousComponents);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static CompiledScript compileCodeGenerator(ConfigurationComponentTypeId systemComponent, IMcuIdentification mcuIdentification) {
        CompiledScript compiledScript = null;
        Object[] scriptFileFolders = S32DSProjectAdapter.getScriptFileFolders(systemComponent, mcuIdentification);
        ScriptFileProvider scriptFileProvider = new ScriptFileProvider((String[])scriptFileFolders);
        File file = scriptFileProvider.findScriptFile(TOOLCHAIN_SETTINGS_JS_FILENAME);
        if (file != null) {
            compiledScript = JavaScriptHelper.compile((File)file);
            if (compiledScript == null) {
                LOGGER.warning("Compilation of code generator failed!");
            }
        } else {
            LOGGER.severe(MessageFormat.format("Code generator script {0} not found at these paths: {1}", TOOLCHAIN_SETTINGS_JS_FILENAME, Arrays.toString(scriptFileFolders)));
        }
        return compiledScript;
    }

    private static String[] getScriptFileFolders(ConfigurationComponentTypeId systemComponent, IMcuIdentification mcuIdentification) {
        String componentsDir = ProcessorFilterForPeripherals.getInstance().getPeripheralsComponentsDir(mcuIdentification);
        String systemCompDir = String.valueOf(componentsDir) + File.separator + systemComponent.getTypeId();
        return new String[]{systemCompDir};
    }

    private static ConfigurationComponentTypeId getSystemComponent(Collection<ConfigurationComponentTypeId> collection, IMcuIdentification mcuIdentification) {
        for (ConfigurationComponentTypeId item : collection) {
            if (!item.getTypeId().equals("system")) continue;
            return item;
        }
        LOGGER.severe(String.format("Peripherals configuration component \"%1s\" either does not exist or its version is not supported by the %2s MCU", "system", mcuIdentification.getPackage()));
        return null;
    }

    public boolean addComponent(String compId) {
        if (!this.isProjectAccessible()) {
            return false;
        }
        if (this.prjHandler == null) {
            return false;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(compId);
        try {
            return this.prjHandler.addComponent(ids, true, true, true, false);
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            assert (false);
            return false;
        }
    }

    public boolean addComponents(List<String> ids) {
        return this.prjHandler.addComponent(ids, true, true, true, false);
    }

    public ISdkComponentInProject getSdkComponent(String id) {
        List<ComponentType> comps;
        this.setSdkComponentDetector(new UctSdkComponentInProjectDetector((IToolchainProjectWithSdk)this));
        ISdkComponentInProject component = super.getSdkComponent(id);
        if (component != null) {
            return component;
        }
        if (!this.isProjectAccessible()) {
            return null;
        }
        List<ComponentType> list = comps = this.prjHandler != null ? this.prjHandler.getComponents() : CollectionsUtils.emptyUnmodifiableList();
        if (comps == null) {
            return null;
        }
        ComponentType comp = (ComponentType)CollectionsUtils.findAny(comps, c -> id.equals(c.getId()));
        if (comp == null) {
            return null;
        }
        return new SdkComponentInProject(comp.getId(), comp.getVersion());
    }

    public ISDKManifest getLoadedManifest() {
        return this.prjHandler.getLoadedManifest();
    }
}

