/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.internal.core;

import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.uct.core.ISDKProjectHandler;
import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.core.ProjectContextHelper;
import com.nxp.s32ds.cle.uct.core.ProjectUtils;
import com.nxp.s32ds.cle.uct.exceptions.SDKException;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreType;
import com.nxp.s32ds.cle.uct.manifest.xml.DebugConfigurationType;
import com.nxp.s32ds.cle.uct.manifest.xml.DefineType;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.manifest.xml.IdentifiableType;
import com.nxp.s32ds.cle.uct.manifest.xml.PackageType;
import com.nxp.s32ds.cle.uct.manifest.xml.SourceType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.OptionValueHolder;
import com.nxp.s32ds.cle.uct.providers.ProjectParameters;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import com.nxp.s32ds.cle.uct.providers.SDKUIUtils;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public class SDKProjectHandler
implements ISDKProjectHandler {
    private IProject project;
    private ProjectContextHelper prjHelper;
    private Map<String, String> context;
    private ISharedConfiguration sharedCfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
    private ISDKManifest manifest;
    private SDKManifestProvider provider;
    private DeviceType device;
    private CoreType core;
    private CompilerType compiler;
    private String sdkName;
    private final ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
    protected static final Logger LOGGER = LogManager.getLogger(SDKProjectHandler.class);
    private static final String KEY_PROCESSOR = "processor";
    private static final String KEY_PROCESSOR_REV = "revision";
    private static final String KEY_TOOLCHAIN = "toolchain";
    private static final String KEY_TOOLCHAIN_ID = "toolchainId";
    private static final String KEY_SDK_PATH = "uctSdk";
    private static final String KEY_SDK_EXTERNAL_ID = "sdkExternalId";

    public SDKProjectHandler(IProject project, Map<String, String> context) {
        this.project = project;
        this.prjHelper = new ProjectContextHelper(project);
        this.context = this.resolveContext(context);
    }

    public SDKProjectHandler(IProject project) {
        this(project, null);
    }

    private Map<String, String> resolveContext(Map<String, String> context) {
        HashMap<String, String> resolved = new HashMap<String, String>();
        resolved.put(KEY_TOOLCHAIN, this.prjHelper.getToolchainName());
        resolved.put(KEY_TOOLCHAIN_ID, this.prjHelper.getToolchainId());
        if (context != null) {
            this.addKey(context, KEY_SDK_PATH, resolved);
            this.addKey(context, KEY_SDK_EXTERNAL_ID, resolved);
            this.addKey(context, "com.nxp.s32ds.cle.runtime.hardware.registry.device.id", resolved, KEY_PROCESSOR);
            this.addKey(context, "com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", resolved, KEY_PROCESSOR_REV);
        }
        return resolved;
    }

    private void addKey(Map<String, String> context, String key, Map<String, String> resolved) {
        this.addKey(context, key, resolved, key);
    }

    private void addKey(Map<String, String> context, String key1, Map<String, String> resolved, String key2) {
        String value;
        if (context.containsKey(key1) && !UtilsText.isEmpty((String)(value = context.get(key1)))) {
            resolved.put(key2, value);
        }
    }

    @Override
    public String getProjectName() {
        if (this.project != null) {
            return this.project.getName();
        }
        return null;
    }

    @Override
    public String getToolchainId() {
        String value = this.context.get(KEY_TOOLCHAIN_ID);
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String getToolchain() {
        String value = this.context.get(KEY_TOOLCHAIN);
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String getProcessor() {
        String value = this.context.get(KEY_PROCESSOR);
        if (value != null) {
            return ProjectUtils.join(value, this.context.get(KEY_PROCESSOR_REV));
        }
        value = this.prjHelper.getProcessor();
        if (value != null) {
            return value;
        }
        return this.sharedCfg.getCommonConfig().getMcu();
    }

    @Override
    public String getPartNumber() {
        IProcessorMasterToolInfo procLocal;
        ICommonConfig config;
        if (this.sharedCfg != null && !this.sharedCfg.isEmpty() && (config = this.sharedCfg.getCommonConfig()) != null) {
            String mcu = config.getMcu();
            String sdk = config.getSdkVersion();
            if (mcu != null && mcu.equalsIgnoreCase(this.getProcessor()) && sdk != null && sdk.equalsIgnoreCase(this.getSDKId())) {
                return config.getPackage();
            }
        }
        if ((procLocal = this.derivatives.getProcessorMasterToolInfo(this.getProcessor(), this.getSDKId())) != null) {
            return procLocal.getDefaultPartNumber();
        }
        return null;
    }

    @Override
    public String getSDKId() {
        String sdkId = this.context.get(KEY_SDK_EXTERNAL_ID);
        if (sdkId == null) {
            Collection list;
            SdkDescriptor sdk = this.prjHelper.getSDK();
            if (sdk != null) {
                this.sdkName = sdk.getDescription();
                return sdk.getExternalId();
            }
            String processor = this.getProcessor();
            if (processor != null && !processor.isEmpty() && !(list = this.derivatives.getAllSwtoolsFolderIDsForMasterTool(this.getProcessor())).isEmpty() && (sdkId = (String)CollectionsUtils.first((Collection)this.derivatives.getAllSwtoolsFolderIDsForMasterTool(this.getProcessor()))) == null) {
                LOGGER.log(Level.SEVERE, "Could not find any SDK id");
            }
        }
        return sdkId;
    }

    @Override
    public String getSDKPath() {
        String path = this.context.get(KEY_SDK_PATH);
        if (path == null) {
            SdkDescriptor sdkDescriptor = this.prjHelper.getSDK();
            if (sdkDescriptor != null) {
                this.sdkName = sdkDescriptor.getDescription();
                EnvironmentSdkDescriptor env = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkDescriptor.getId());
                if (env != null && SDKProjectHandler.isSdkEnvVariableExists(env)) {
                    try {
                        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(env.getValue(), true);
                    }
                    catch (CoreException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            } else {
                LOGGER.log(Level.SEVERE, "Could not find any SDK");
            }
        }
        return path;
    }

    private static boolean isSdkEnvVariableExists(EnvironmentSdkDescriptor env) {
        return (env.isSystem() ? System.getenv(env.getName()) : VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(env.getName())) != null;
    }

    @Override
    public String getSDKName() {
        return this.sdkName;
    }

    @Override
    public String getCoreId() {
        SWToolsPlatform.CoresInfoLoader coresInfo;
        String sdkId = this.getSDKId();
        if (sdkId != null && (coresInfo = SWToolsPlatform.getCoresInfo((String)this.getProcessor(), (String)sdkId, (ISupportedDerivativesForSwTools)this.derivatives)) != null) {
            return this.getCoreId(coresInfo.cores);
        }
        return null;
    }

    @Override
    public String getCoreId(Collection<ProcessorCore> cores) {
        return this.prjHelper.getCoreId(cores);
    }

    @Override
    public boolean addComponent(final List<String> ids, final boolean standalone, final boolean importOtherFiles, boolean updateCompMap, final boolean dontShowDialog) throws NullPointerException {
        if (ids == null) {
            throw new NullPointerException();
        }
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
                }
            });
        }
        final ComponentRunnableProgress runnableProcess = new ComponentRunnableProgress(this){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("S32 Config Tools project update: " + project.getName(), -1);
                    ArrayList<ComponentType> components = new ArrayList<ComponentType>();
                    ArrayList<ComponentType> enabledComponents = new ArrayList<ComponentType>();
                    ProjectParameters projectParameters = this.setupOperation(ids, components, enabledComponents, standalone, importOtherFiles, monitor, false);
                    if (projectParameters == null) {
                        this.setResult(false);
                        return;
                    }
                    projectParameters.setOptions(new HashMap<String, OptionValueHolder>());
                    Map<ComponentType, List<SourceType>> projectSources = projectParameters.getSources();
                    if (!ids.isEmpty() && this.hasSources(projectSources)) {
                        boolean addComponents = true;
                        if (!dontShowDialog) {
                            addComponents = this.openConfirmPrompt(Messages.SDKProjectHandler_AddFiles, MessageFormat.format(Messages.SDKProjectHandler_AddFilesAndComponents_OtherProcessor, project.getName()), Messages.SDKProjectHandler_AddFilesAndComponents, sharedCfg.getToolchainProject().getEclipseProject(), projectParameters.getProject(), projectSources);
                        }
                        if (addComponents) {
                            provider.handleFiles(projectParameters, false, monitor);
                            this.setupEntries(projectParameters, true);
                            this.updateLibs(projectParameters);
                            this.updateDefines(components, projectParameters);
                            this.updateComponentsMap(enabledComponents, true);
                            project.refreshLocal(2, monitor);
                            this.setResult(true);
                            if (ProjectPropertiesManager.getSyncWithPeriphToolPreferencesStatus(project)) {
                                projectParameters.getEnabledComponents().forEach(component -> {
                                    String componentId = component.getId();
                                    if (!ids.contains(componentId)) {
                                        ids.add(componentId);
                                    }
                                });
                            }
                        }
                    } else {
                        this.setResult(false);
                    }
                    monitor.done();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    this.setResult(false);
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnableProcess);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        LOGGER.log(Level.SEVERE, Messages.SDKProjectHandler_SDKCompManagement, e);
                        runnableProcess.setResult(false);
                    }
                }
            });
        } else {
            try {
                runnableProcess.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, Messages.SDKProjectHandler_SDKCompManagement, e);
                runnableProcess.setResult(false);
            }
        }
        return runnableProcess.getResult();
    }

    private void updateComponentsMap(List<ComponentType> enabledComponents, boolean add) {
        String componentId;
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> componentsList = new ArrayList<String>();
        String ec = ProjectPropertiesManager.getEntry(this.project, "sdkComponents");
        if (ec != null && !ec.trim().isEmpty()) {
            String[] stringArray = ec.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                componentsList.add(component.trim());
                ++n2;
            }
        }
        String result = "";
        if (add) {
            for (ComponentType item : enabledComponents) {
                componentId = item.getId().trim();
                if (componentsList.contains(componentId)) continue;
                componentsList.add(componentId);
            }
        } else {
            for (ComponentType item : enabledComponents) {
                componentId = item.getId().trim();
                if (!componentsList.contains(componentId)) continue;
                componentsList.remove(componentId);
            }
        }
        result = componentsList.isEmpty() ? " " : String.join((CharSequence)";", componentsList);
        map.put("sdkComponents", result);
        ProjectPropertiesManager.save(this.project, map, CoreModel.getDefault().getProjectDescription(this.project));
    }

    private void updateDefines(List<ComponentType> components, ProjectParameters projectParameters) throws CoreException, Exception {
        ICProject cProject = CoreModel.getDefault().create(this.project);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription desC = mngr.createProjectDescription(cProject.getProject(), true);
        boolean isCpp = ProjectUtils.isCppProject(desC.getProject());
        ArrayList<ComponentType> elements = new ArrayList<ComponentType>();
        elements.addAll(components);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = desC.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
            IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
            IToolChain toolchain = conf.getToolChain();
            HashMap<String, OptionValueHolder> options = new HashMap<String, OptionValueHolder>();
            IOption option = null;
            ITool[] iToolArray = toolchain.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool iTool = iToolArray[n4];
                option = isCpp ? iTool.getOptionById("gnu.cpp.compiler.option.preprocessor.def") : iTool.getOptionById("gnu.c.compiler.option.preprocessor.def.symbols");
                if (option != null) {
                    String[] values = (option = iTool.getOptionToSet(option, false)).getDefinedSymbols();
                    if (values == null) break;
                    OptionValueHolder holder = new OptionValueHolder();
                    String[] stringArray = values;
                    int n5 = values.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String value = stringArray[n6];
                        Pattern pattern = Pattern.compile("=\"(.*)\"|\\\\\"(.*)\\\"");
                        Matcher matcher = pattern.matcher(value);
                        if (!matcher.find()) {
                            holder.add(value.replace("\"", "").trim());
                        } else {
                            holder.add(value);
                        }
                        ++n6;
                    }
                    options.put(option.getBaseId(), holder);
                    break;
                }
                ++n4;
            }
            for (IdentifiableType identifiableType : elements) {
                IdentifiableType.Defines defines = identifiableType.getDefines();
                if (defines == null || defines.getDefine() == null) continue;
                for (DefineType define : defines.getDefine()) {
                    if (define.getIdRefs().isEmpty()) {
                        SDKManifestProvider.addDefine(options, isCpp, define);
                        continue;
                    }
                    for (Object ref : define.getIdRefs()) {
                        if (!(ref instanceof DebugConfigurationType)) continue;
                        DebugConfigurationType debugCfg = (DebugConfigurationType)ref;
                        if (!cfgs.getId().toLowerCase().contains(debugCfg.getId())) continue;
                        SDKManifestProvider.addDefine(options, isCpp, define);
                    }
                }
            }
            if (option != null) {
                OptionValueHolder optionValueHolder = (OptionValueHolder)options.get(option.getBaseId());
                String[] array = optionValueHolder.getValues("com.nxp.s32ds.default.config").toArray(new String[optionValueHolder.getValues("com.nxp.s32ds.default.config").size()]);
                ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)option.getOptionHolder(), (IOption)option, (String[])array);
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(this.project, desC);
    }

    private void updateLibs(ProjectParameters projectParameters) throws Exception {
        ICProject cProject = CoreModel.getDefault().create(this.project);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription desC = mngr.createProjectDescription(cProject.getProject(), true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = desC.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
            IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
            IToolChain toolchain = conf.getToolChain();
            ITool[] iToolArray = toolchain.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                SDKManifestProvider.setOption(conf, projectParameters.getOptions(), (IHoldsOptions)tool);
                ++n4;
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(this.project, desC);
    }

    private void removeLibs(ProjectParameters projectParameters) throws Exception {
        ICProject cProject = CoreModel.getDefault().create(this.project);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription desC = mngr.createProjectDescription(cProject.getProject(), true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = desC.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
            IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
            IToolChain toolchain = conf.getToolChain();
            ITool[] iToolArray = toolchain.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                SDKManifestProvider.removeOption(conf, projectParameters.getOptions(), (IHoldsOptions)tool);
                ++n4;
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(this.project, desC);
    }

    private void setupEntries(ProjectParameters projectParameters, boolean add) throws CoreException {
        ICConfigurationDescription[] configDecriptions;
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(projectParameters.getProject(), true);
        List<ICSettingEntry> entries = projectParameters.getBuilderEntries();
        ArrayList<ICLanguageSettingEntry> includeEntries = new ArrayList<ICLanguageSettingEntry>(Arrays.asList(SDKManifestProvider.getIncludes(entries)));
        ArrayList<ICSourceEntry> newSourceEntries = new ArrayList<ICSourceEntry>(Arrays.asList(SDKManifestProvider.getSources(entries)));
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDecriptions = des.getConfigurations();
        int n = configDecriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting[] settings;
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = settings = projectRoot.getLanguageSettings();
            int n3 = settings.length;
            int n4 = 0;
            while (n4 < n3) {
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                ICLanguageSettingEntry[] oldEntries = setting.getSettingEntries(1);
                includeEntries.clear();
                includeEntries.addAll(Arrays.asList(SDKManifestProvider.getIncludes(entries)));
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray = oldEntries;
                int n5 = oldEntries.length;
                int n6 = 0;
                while (n6 < n5) {
                    ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n6];
                    if (add) {
                        if (!includeEntries.contains(entry)) {
                            includeEntries.add(entry);
                        }
                    } else {
                        boolean entryFound = false;
                        Object[] objectArray = includeEntries.toArray();
                        int n7 = objectArray.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            Object obj = objectArray[n8];
                            ICLanguageSettingEntry en = (ICLanguageSettingEntry)obj;
                            if (en.getValue().equals(entry.getValue())) {
                                includeEntries.remove(en);
                                entryFound = true;
                            }
                            ++n8;
                        }
                        if (!entryFound) {
                            includeEntries.add(entry);
                        }
                    }
                    ++n6;
                }
                setting.setSettingEntries(1, includeEntries.toArray(new ICLanguageSettingEntry[includeEntries.size()]));
                ++n4;
            }
            CConfigurationData data = configDescription.getConfigurationData();
            ArrayList<ICSourceEntry> sourceEntries = new ArrayList<ICSourceEntry>(Arrays.asList(data.getSourceEntries()));
            boolean newSourceEntryFound = false;
            for (ICSourceEntry entry : newSourceEntries) {
                if (this.sourceEntryExists(sourceEntries, entry)) continue;
                sourceEntries.add(entry);
                newSourceEntryFound = true;
            }
            if (newSourceEntryFound) {
                data.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(projectParameters.getProject(), des);
    }

    private boolean sourceEntryExists(List<ICSourceEntry> entries, ICSourceEntry entry) {
        for (ICSourceEntry e : entries) {
            if (!e.getName().equals(entry.getName())) continue;
            return true;
        }
        return entries.contains(entry);
    }

    private ProjectParameters setupOperation(List<String> ids, List<ComponentType> components, List<ComponentType> enabledComponents, boolean standalone, boolean importOtherFiles, IProgressMonitor monitor, boolean isRemoveProcess) throws Exception {
        CompilerEnum type;
        String[] natures;
        ISDKManifest manifestLoc = this.getLoadedManifest();
        if (manifestLoc == null) {
            LOGGER.log(Level.SEVERE, "SDK manifest instance couldn't be found");
            return null;
        }
        for (String id : ids) {
            List<ComponentType> result = manifestLoc.getComponentsById(id, false);
            if (!result.isEmpty()) {
                components.addAll(result);
                continue;
            }
            String message = NLS.bind((String)Messages.SDKProjectHandler_CannotFindComp, (Object)id, (Object)manifestLoc.getManifestSimpleName());
            LOGGER.log(Level.WARNING, message);
        }
        String nature = "";
        IProjectDescription des = this.project.getDescription();
        String[] stringArray = natures = des.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.equals("org.eclipse.cdt.core.cnature")) {
                nature = "org.eclipse.cdt.core.cnature";
                break;
            }
            if (n3.equals("org.eclipse.cdt.core.ccnature")) {
                nature = "org.eclipse.cdt.core.ccnature";
                break;
            }
            ++n2;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project, (boolean)true);
        String pType = null;
        if (info != null) {
            pType = info.getManagedProject().getProjectType().getId();
        }
        if (this.device == null) {
            this.device = SDKProjectHandler.getDevice(manifestLoc, this.getProcessor());
        }
        PackageType pkg = null;
        if (this.device != null) {
            pkg = this.device.getPackage().get(0);
        }
        if (this.compiler == null && (type = CompilerEnum.fromId(this.getToolchainId())) != null) {
            this.compiler = new CompilerType();
            this.compiler.setType(type);
        }
        ArrayList<ICSettingEntry> entries = new ArrayList<ICSettingEntry>();
        ProjectParameters projectParameters = new ProjectParameters(manifestLoc, this.device, this.core, pkg, null, this.compiler, this.project.getName(), null, nature, pType, standalone, components, false, null, true);
        projectParameters.setUseOtherFiles(importOtherFiles);
        IFolder srcFolder = this.project.getFolder("/src");
        if (!srcFolder.exists()) {
            srcFolder.create(true, true, monitor);
            entries.add((ICSettingEntry)new CSourceEntry(srcFolder.getName(), null, 4));
            entries.add((ICSettingEntry)this.provider.createIncludeEntry(srcFolder.getFullPath().toPortableString(), this.project.getName(), null, null, null));
        }
        IFolder docFolder = this.project.getFolder("/doc");
        srcFolder.refreshLocal(2, monitor);
        projectParameters.setSourceFolder(srcFolder);
        projectParameters.setDocFolder(docFolder);
        projectParameters.setProject(this.project);
        List<ComponentType> projectComponents = null;
        if (isRemoveProcess) {
            projectComponents = SDKProjectHandler.getComponents(this.project, manifestLoc, new ArrayList<ComponentType>());
            projectComponents.removeAll(components);
        }
        projectParameters.setEnabledComponents(enabledComponents);
        projectParameters.setSources(new HashMap<ComponentType, List<SourceType>>());
        this.provider.addDependency(manifestLoc, this.device, this.core, components, projectParameters, projectComponents);
        projectParameters.setBuilderEntries(entries);
        return projectParameters;
    }

    public static List<ComponentType> getComponents(IProject project, ISDKManifest manifest, List<ComponentType> dependencies) {
        ArrayList<ComponentType> components = new ArrayList<ComponentType>();
        String entry = ProjectPropertiesManager.getEntry(project, "sdkComponents");
        if (entry != null) {
            String[] ids;
            String[] stringArray = ids = entry.split(";");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                List<ComponentType> result = manifest.getComponentsById(id, true);
                for (ComponentType component : result) {
                    if (component == null || component.getType().equals((Object)ComponentTypeEnum.CMSIS_INCLUDE) || component.getType().equals((Object)ComponentTypeEnum.CMSIS) || component.getType().equals((Object)ComponentTypeEnum.STARTUP) || component.getType().equals((Object)ComponentTypeEnum.PROJECT_TEMPLATE)) continue;
                    try {
                        manifest.getDependencies(component, dependencies);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    if (component == null) continue;
                    components.add(component);
                }
                ++n2;
            }
        }
        return components;
    }

    protected boolean hasSources(Map<ComponentType, List<SourceType>> map) {
        Set<ComponentType> keys = map.keySet();
        Iterator<ComponentType> it = keys.iterator();
        boolean hasSources = false;
        while (it.hasNext()) {
            ComponentType key = it.next();
            List<SourceType> value = map.get(key);
            if (value.isEmpty()) continue;
            hasSources = true;
        }
        return hasSources;
    }

    private void loadManifest() {
        this.manifest = this.getManifest();
        if (this.manifest != null) {
            this.provider = this.manifest.getProvider();
        }
    }

    @Override
    public ISDKManifest getLoadedManifest() {
        if (this.manifest == null) {
            this.loadManifest();
        }
        return this.manifest;
    }

    public ISDKManifest getManifest() {
        Optional first;
        String sdkLocation = this.getSDKPath();
        if (sdkLocation == null && (first = KEPreferences.getRecentSdkPaths().stream().findFirst()).isPresent()) {
            sdkLocation = (String)first.get();
        }
        if (sdkLocation != null) {
            SDKManifestProvider newProvider = null;
            try {
                for (SDKManifestProvider manProv : SDKManifestProvider.getInstance()) {
                    String currentLoc = new File(sdkLocation).getCanonicalPath();
                    if (!manProv.getLocation().getCanonicalPath().equals(currentLoc)) continue;
                    for (ISDKManifest pack : manProv.getManifests()) {
                        if (!pack.isActive()) continue;
                        return pack;
                    }
                }
                newProvider = new SDKManifestProvider(sdkLocation);
                newProvider.refresh();
            }
            catch (SDKException | IOException | JAXBException | SAXException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            if (newProvider != null) {
                for (ISDKManifest pack : newProvider.getManifests()) {
                    if (!pack.isActive()) continue;
                    return pack;
                }
            }
        } else {
            LOGGER.log(Level.SEVERE, "Error: could not find sdk manifest path");
        }
        return null;
    }

    protected static String getEntry(ICStorageElement storage, String entry) {
        ICStorageElement[] settings = storage.getChildrenByName(entry);
        if (settings != null && settings.length != 0) {
            return settings[0].getValue();
        }
        return null;
    }

    public static DeviceType getDevice(ISDKManifest manifest, String chip) {
        DeviceType device = null;
        if (chip != null && manifest != null && manifest.isActive()) {
            for (DeviceType d : manifest.getDevices()) {
                if (!d.getId().equals(chip)) continue;
                device = d;
                break;
            }
        }
        return device;
    }

    @Override
    public boolean remComponent(final List<String> ids, final boolean dontShowDialog) throws NullPointerException {
        if (ids == null) {
            throw new NullPointerException(Messages.SDKProjectHandler_NonNullIds);
        }
        final ComponentRunnableProgress runnableProcess = new ComponentRunnableProgress(this){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(String.valueOf(Messages.SDKProjectHandler_DelComponents) + project.getName(), -1);
                    ArrayList<ComponentType> components = new ArrayList<ComponentType>();
                    ArrayList<ComponentType> enabledComponents = new ArrayList<ComponentType>();
                    ProjectParameters projectParameters = this.setupOperation(ids, components, enabledComponents, true, true, monitor, true);
                    if (projectParameters == null) {
                        this.setResult(false);
                        return;
                    }
                    projectParameters.setOptions(new HashMap<String, OptionValueHolder>());
                    if (!ids.isEmpty() && this.hasSources(projectParameters.getSources())) {
                        boolean removeComponents = true;
                        if (!dontShowDialog) {
                            removeComponents = this.openConfirmPrompt(Messages.SDKProjectHandler_RemoveFiles, MessageFormat.format(Messages.SDKProjectHandler_RemoveFilesAndComponents_OtherProcessor, project.getName()), Messages.SDKProjectHandler_RemoveFilesAndComponents, sharedCfg.getToolchainProject().getEclipseProject(), projectParameters.getProject(), projectParameters.getSources());
                        }
                        if (removeComponents) {
                            provider.handleFiles(projectParameters, false, monitor);
                            provider.deleteFiles(projectParameters, monitor);
                            this.setupEntries(projectParameters, false);
                            this.removeLibs(projectParameters);
                            this.updateComponentsMap(enabledComponents, false);
                            project.refreshLocal(2, monitor);
                        }
                    }
                    monitor.done();
                    this.setResult(true);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    this.setResult(false);
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)runnableProcess);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        LOGGER.log(Level.SEVERE, Messages.SDKProjectHandler_SDKCompManagement, e);
                        runnableProcess.setResult(false);
                    }
                }
            });
        } else {
            try {
                runnableProcess.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, Messages.SDKProjectHandler_SDKCompManagement, e);
                runnableProcess.setResult(false);
            }
        }
        return runnableProcess.getResult();
    }

    private boolean openConfirmPrompt(String msg1, String msg2, String msg3, IProject mcuProject, IProject selectedProject, Map<ComponentType, List<SourceType>> projectSources) {
        String dialogMessage = msg1;
        int messageType = 3;
        if (ProjectPropertiesManager.getSyncWithPeriphToolPreferencesStatus(this.project)) {
            if (!mcuProject.equals((Object)selectedProject)) {
                dialogMessage = msg2;
                messageType = 4;
            } else {
                dialogMessage = msg3;
            }
        }
        return SDKUIUtils.openConfirmPrompt(dialogMessage, messageType, projectSources);
    }

    @Override
    public List<ComponentType> getComponents() {
        ISDKManifest localManifest = this.getLoadedManifest();
        if (localManifest != null) {
            return SDKProjectHandler.getComponents(this.project, this.manifest, new ArrayList<ComponentType>());
        }
        return null;
    }

    @Override
    public boolean isComponentInSdk(String id) {
        ISDKManifest localManifest = this.getLoadedManifest();
        if (localManifest != null) {
            return !localManifest.getComponentsById(id, true).isEmpty() || !localManifest.getComponentsById(id, false).isEmpty();
        }
        return false;
    }

    class ComponentRunnableProgress
    implements IRunnableWithProgress {
        private boolean result;

        ComponentRunnableProgress() {
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
        }
    }
}

