/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.providers;

import com.nxp.s32ds.cle.uct.manifest.xml.BoardType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.ProjectParameters;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import org.eclipse.core.runtime.IProgressMonitor;

public class SDKSoftwareProvider {
    public static ComponentType getBoardComponent(String boardId, DeviceType device) {
        for (SDKManifestProvider provider : SDKManifestProvider.getInstance()) {
            for (ISDKManifest manifest : provider.getManifests()) {
                for (ComponentType component : manifest.getComponents(ComponentTypeEnum.PROJECT_TEMPLATE, device)) {
                    if (!component.getName().equals(boardId)) continue;
                    return component;
                }
            }
        }
        return null;
    }

    public static void handleSources(ProjectParameters projectParameters, ComponentType component, boolean includeOnly, boolean forceOverwrite, IProgressMonitor monitor) {
        for (SDKManifestProvider provider : SDKManifestProvider.getInstance()) {
            for (ISDKManifest manifest : provider.getManifests()) {
                if (manifest.getInstance().getComponents() == null) continue;
                for (ComponentType c : manifest.getInstance().getComponents().getComponent()) {
                    if (!c.getId().equals(component.getId())) continue;
                    ISDKManifest oldSdk = projectParameters.getPack();
                    try {
                        try {
                            projectParameters.setPack(manifest);
                            provider.handleSources(projectParameters, component, includeOnly, forceOverwrite, monitor);
                        }
                        catch (Exception exception) {
                            projectParameters.setPack(oldSdk);
                        }
                    }
                    finally {
                        projectParameters.setPack(oldSdk);
                    }
                    return;
                }
            }
        }
    }

    public static ISDKManifest getBoardManifest(BoardType board) {
        for (SDKManifestProvider provider : SDKManifestProvider.getInstance()) {
            for (ISDKManifest manifest : provider.getManifests()) {
                if (!manifest.getBoards().contains(board)) continue;
                return manifest;
            }
        }
        return null;
    }
}

