/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.intro.actions;

import com.nxp.s32ds.ext.rcp.internal.intro.IntroActivator;
import com.nxp.s32ds.ext.rcp.internal.intro.Messages;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class OpenUrlAction
extends Action
implements IIntroAction {
    private static final String REGEX_DATA_BETWEEN_QUOTES = "\"([^\"]*)\"";
    private static final String URL = "url";
    Properties params = null;

    public void initialize(IIntroSite site, Properties params) {
        this.params = params;
    }

    public void run(IIntroSite site, Properties params) {
        URL urlPath;
        String url = params.getProperty(URL);
        String path = "";
        if (url == null || url.isEmpty()) {
            String msg = NLS.bind((String)Messages.openAbstractWizardAction_propertyNotFound, (Object)URL);
            IntroActivator.getInstance().logError(msg);
            return;
        }
        try {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(url);
        }
        catch (CoreException e) {
            IntroActivator.getInstance().log(e.getStatus());
            return;
        }
        try {
            URI uri = Paths.get(path, new String[0]).toUri();
            urlPath = uri.toURL();
        }
        catch (IOException iOException) {
            String msg = NLS.bind((String)Messages.openUrlAction_urlNotFound, (Object)URL);
            IntroActivator.getInstance().logError(msg);
            return;
        }
        try {
            Optional<String> launcher = OpenUrlAction.getDefaultBrowserLauncher();
            if (OpenUrlAction.isEdgeBrowser(launcher)) {
                String p = urlPath.getPath();
                if (p.startsWith("/")) {
                    p = p.substring(1);
                }
                String program = launcher.get();
                if (p.endsWith("txt")) {
                    program = "notepad";
                }
                ProcessBuilder pb = new ProcessBuilder("cmd", "/C", program, p);
                pb.start();
                return;
            }
        }
        catch (IOException ex) {
            IntroActivator.getInstance().logError(ex.getMessage(), ex);
        }
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(urlPath);
        }
        catch (CoreException e) {
            IntroActivator.getInstance().log(e.getStatus());
            return;
        }
    }

    private static Optional<String> getDefaultBrowserLauncher() {
        Program program = Program.findProgram((String)"html");
        try {
            Field f = program.getClass().getDeclaredField("command");
            f.setAccessible(true);
            return OpenUrlAction.extractProgramNameByString((String)f.get(program));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            IntroActivator.getInstance().logError("Failed to get default browser", ex);
            return Optional.empty();
        }
    }

    private static boolean isEdgeBrowser(Optional<String> launcher) {
        return launcher.map(l -> l.contains("LaunchWinApp.exe")).orElse(false);
    }

    public static Optional<String> extractProgramNameByString(String fullCommand) {
        Pattern p = Pattern.compile(REGEX_DATA_BETWEEN_QUOTES);
        Matcher m = p.matcher(fullCommand);
        if (m.find()) {
            return Optional.ofNullable(m.group(1));
        }
        return Optional.empty();
    }
}

