/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.s32ds.cdt.core2;

import org.eclipse.cdt.core.IErrorParser;

/**
 * Interface to provide a mechanism to quickly discriminate whether a line matches a pattern
 * based on a simple expression, so that error parser's string can be coalesced into a single
 * regular expression.
 * 
 * @since 5.1
 */
public interface IFSLErrorParser4Epl extends IErrorParser {

	/**
	 * If the error parser can define a simple regular expression
	 * to determine whether the IErrorParser.processLine(String, ErrorParserManager) will
	 * be called given a specific line.
	 * */
	String getRegularExpresion();
}