/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * Copyright 2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Freescale Semiconductor - modified by and for Freescale
 *******************************************************************************/

package com.freescale.system.browser.epl;

/**
 * Represents a section descriptor on the tabbed sections extensions.
 * 
 * @author Anthony Hunter
 * @version 1.0
 */
public interface ISectionDescriptorEpl {
	/**
	 * Get the unique identifier for the section.
	 * 
	 * @return the unique identifier for the section.
	 */
	public String getId();

	/**
	 * Get the target tab where this section will appear.
	 * 
	 * @return the target tab where this section will appear.
	 */
	public String getTargetTab();			
}
