/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * Copyright 2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Freescale Semiconductor - modified by and for Freescale
 *******************************************************************************/

package com.freescale.system.browser.epl;

import com.freescale.system.browser.epl.TabDescriptorEpl;


/**
 * A listener interested in tab selection events that occur for the tabbed
 * sheet page.
 * 
 * @author Anthony Hunter
 * @version 1.0
 */
public interface ITabSelectionListenerEpl {

	/**
	 * Notifies this listener that the selected tab has changed.
	 * 
	 * @param tabDescriptor
	 *            the selected tab descriptor.
	 */
	public void tabSelected(TabDescriptorEpl tabDescriptor);
}
