/*******************************************************************************
 * Copyright (c) 2006 Freescale Semiconductor.
 * Copyright 2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 * 
 * Contributors:
 *     Freescale Semiconductor - initial API and implementation
 *******************************************************************************/

package com.freescale.system.browser.epl;

import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.IPageBookViewPage;
import com.freescale.system.browser2.OSAwarenessData2;


/**
 * Interface any tabbed page must implement. 
 */
public interface ITabbedPageEpl extends IPageBookViewPage, ISelectionListener {

	/**
	 * Get the instance of the contributor that owns this page (contributes 
	 * this page to the System Browser).
	 *
	 * @return - the owner of the page, the contributor that implements the
	 *         extension points and provides the page to the System Browser View
	 */
	public ITabbedPageContributorEpl getContributor();
	
	/**
	 * Called when the active context for the System Browser changes. That's
	 * the active debug context (the selection in the Debug view)
	 * 
	 * @param newSession the active debug context
	 */
	public void setPageInput(OSAwarenessData2 newSession);
}
