/*******************************************************************************
 * Copyright (c) 2009, 2012 Wind River Systems, Inc. and others.
 * Copyright 2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 * 
 * Contributors:
 *     Doug Schaefer - initial API and implementation
 *******************************************************************************/

package com.freescale.s32ds.ext.cdt.utils.epl;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;

import com.freescale.s32ds.cdt.core2.PathEnvironmentVariableEpl;

/**
 * This class is copied from org.eclipse.cdt.build.crossgcc. The difference here
 * is that PathEnvironmentVariable checks whether the path is variable relative
 * and resolves it before storage.
 **/
public class CrossEnvironmentVariableSupplierEpl implements
		IConfigurationEnvironmentVariableSupplier {

	public static final String MSYS_LOC_VAR = "${MSYS_LOC}";

	@Override
	public IBuildEnvironmentVariable getVariable(String variableName,
			IConfiguration configuration, IEnvironmentVariableProvider provider) {
		if (PathEnvironmentVariableEpl.isVar(variableName)) {
            return PathEnvironmentVariableEpl.create(configuration, MSYS_LOC_VAR);
        } else {
            return null;
        }
	}

	@Override
	public IBuildEnvironmentVariable[] getVariables(
			IConfiguration configuration, IEnvironmentVariableProvider provider) {
		IBuildEnvironmentVariable path = PathEnvironmentVariableEpl.create(
				configuration, MSYS_LOC_VAR);
		return path != null ? new IBuildEnvironmentVariable[] { path }
				: new IBuildEnvironmentVariable[0];
	}
}
