/*******************************************************************************
 * Copyright 2023 NXP
 *
 * SPDX-License-Identifier: EPL-1.0
 *******************************************************************************/

package com.freescale.s32ds.ext.cdt.utils.epl.help;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class FSLCCorePluginEpl extends Plugin {
	
	public static final String PLUGIN_ID = "com.freescale.s32ds.ext.cdt.utils.epl"; //$NON-NLS-1$
	
	private static FSLCCorePluginEpl fgCPlugin;
	
	/**
	 * @noreference This constructor is not intended to be referenced by clients.
	 */
	public FSLCCorePluginEpl() {
		super();
		fgCPlugin = this;
	}


	public static FSLCCorePluginEpl getDefault() {
		return fgCPlugin;
	}
	
	/**
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public static void log(String e) {
		log(createStatus(e));
	}

	/**
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public static void log(Throwable e) {
		String msg= e.getMessage();
		if (msg == null) {
			log("Error", e); //$NON-NLS-1$
		} else {
			log("Error: " + msg, e); //$NON-NLS-1$
		}
	}

	/**
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public static void log(String message, Throwable e) {
		Throwable nestedException;
		if (e instanceof CModelException
				&& (nestedException = ((CModelException)e).getException()) != null) {
			e = nestedException;
		}
		log(createStatus(message, e));
	}

	/**
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public static IStatus createStatus(String msg) {
		return createStatus(msg, null);
	}

	/**
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public static IStatus createStatus(String msg, Throwable e) {
		return new Status(IStatus.ERROR, PLUGIN_ID, msg, e);
	}

	/**
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}
	
}
