/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser2;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The activator class represents the eclipse plug-in and its life cycle.
 */
public class SystemBrowserActivator2 extends AbstractUIPlugin {

	/** This plugin's ID */
	private static final String PLUGIN_ID = "com.freescale.system.browser2"; //$NON-NLS-1$
	private static final String EXTENSION_ID = "com.freescale.system.browser"; //$NON-NLS-1$

	/**
	 * The plug-in's singleton instance
	 */
	private static SystemBrowserActivator2 fPlugin;
	
	/**
	 * 
	 * */
	private static BundleContext fgBundleContext;

	/**
	 * Constructor. Initializes the resource bundle and the plug-in 
	 * shared instance.
	 * 
	 * @throws IllegalStateException if the plug-in was already instantiated
	 */
	public SystemBrowserActivator2() {
		super();

		if (fPlugin != null) {
			throw new IllegalStateException(Messages2.Error_Illegal_State);
		}
		fPlugin = this;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		fgBundleContext = context;
		super.start(context);
		
		// Validate our plugin ID constant 
		if (!getBundle().getSymbolicName().equals(PLUGIN_ID)) {
			throw new IllegalStateException("PLUGIN_ID constant is not correct"); //$NON-NLS-1$
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		fgBundleContext = null;
	}

	/**
	 * Retrieves the singleton instance of this plug-in. The same as getDefault with
	 * a more intuitive name.
	 * 
	 * @return the plug-in instance for this plug-in.
	 */
	public static SystemBrowserActivator2 getPlugin() {
		return fPlugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path.
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(getPluginId(), path);
	}

	/**
	 * @return the plugin id.
	 */
	public static String getPluginId() {
		return PLUGIN_ID;
	}

	public static String getExtensionId() {
		return EXTENSION_ID;
	}

	/**
	 * Returns the bundle context for this plugin.
	 */
     public static BundleContext getBundleContext() {
        return fgBundleContext;
     }
     
     /** */
     public static void log(IStatus status){
    	 fPlugin.getLog().log(status);
 	 }
     
     /** */
     public static void log(int severity, String message){
 		Status status = new Status(severity, PLUGIN_ID, message);
 		fPlugin.getLog().log(status);
 	 }
}
