 /**
 * Copyright 2019 NXP
 * Created: Jan 31, 2019
 */
package com.nxp.swtools.periphs.gui.controller;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.periphs.controller.Controller;

/**
 * Class used to return controllers for Peripherals Tool
 * @author Rares-Mihai Gafton nxf38680
 *
 */
public class PeriphControllerWrapper extends AControllerWrapper {

	/** Whether the controller was disposed */
	private boolean disposed = false;
	
	
	/**
	 * @param controller
	 * @param guiController
	 */
	private PeriphControllerWrapper() {
		super(Controller.getInstance(), PeriphGUIController.getInstance());
	}
	
	/**
	 * Get instance of a Controller. Must be called from UI thread
	 * @return instance of a controller
	 */
	public static PeriphControllerWrapper getInstance() {
		try {
			PeriphControllerWrapper controllerWrapper = SWTFactoryProxy.INSTANCE.getSingletonInstance(PeriphControllerWrapper.class);
			if (controllerWrapper.disposed) {
				throw new IllegalStateException("Controller is disposed");  //$NON-NLS-1$
			}
			return controllerWrapper;
		} catch (InstantiationException | IllegalAccessException e) {
			throw new IllegalStateException("Cannot obtain instance of a controller", e);  //$NON-NLS-1$
		}
	}
	

	/**
	 * Dispose the controller.
	 */
	public void dispose() {
		disposed = true;
	}

}
