/**
 * Copyright 2020 NXP
 * Created: 27 Aug 2020
 */
package com.nxp.swtools.periphs.gui.dialogs.initializationorder;

import java.util.Collection;
import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;

/**
 * Provider for {@link TreeViewer} used in {@link InitializationOrderDialog}
 * @author Tomas Rudolf - nxf31690
 */
public class InitializationOrderProvider implements ITreeContentProvider {

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getElements(java.lang.Object)
	 */
	@Override
	public @NonNull Object @NonNull [] getElements(@NonNull Object inputElement) {
		if (inputElement instanceof Collection) {
			Collection<?> collection = (Collection<?>)inputElement;
			return collection.toArray(new @NonNull Object[collection.size()]);
		}
		return new Object[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	@Override
	public @NonNull Object @NonNull [] getChildren(@NonNull Object parentElement) {
		if (parentElement instanceof InitializationOrderGroup) {
			List<InitializationOrderInstance> instances = ((InitializationOrderGroup)parentElement).getInstances();
			return instances.toArray(new @NonNull InitializationOrderInstance[instances.size()]);
		}
		return new Object[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	@Override
	public @Nullable Object getParent(@NonNull Object element) {
		if (element instanceof InitializationOrderInstance) {
			return ((InitializationOrderInstance) element).getGroup();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	@Override
	public boolean hasChildren(@NonNull Object element) {
		if (element instanceof InitializationOrderGroup) {
			return !((InitializationOrderGroup)element).getInstances().isEmpty();
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	@Override
	public void dispose() {
		// Intentionally empty
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
		// Intentionally empty
	}
}