/**
 * Copyright 2021 NXP
 * Created: Mar 23 2021
 */
package com.nxp.swtools.periphs.gui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.templates.component.ComponentTemplateManagerDialog;

/**
 * Handler used for opening the {@link ComponentTemplateManagerDialog}
 * @author Tomas Rudolf - nxf31690
 */
public class OpenComponentTemplateManagerDialogHandler extends AbstractHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (activeWorkbenchWindow == null) {
			return null;
		}
		Shell shell = activeWorkbenchWindow.getShell();
		if (shell == null) {
			return null;
		}
		ComponentTemplateManagerDialog.open(shell);
		return null;
	}

}
