/**
 * Copyright 2021 NXP               
 * Created: Sep 17, 2021
 */
package com.nxp.swtools.periphs.gui.handler;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.view.MigrationOfferDialog;

/**
 * Handler for opening {@link MigrationOfferDialog} from Peripherals menu
 */
public class OpenMigrationOfferDialogHandler extends AbstractHandler {

	/** Logger of the class */
	private static final Logger LOGGER = LogManager.getLogger(OpenMigrationOfferDialogHandler.class);

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (activeWorkbenchWindow == null) {
			LOGGER.log(Level.SEVERE, "[TOOL] There is no active WorkbenchWindow"); //$NON-NLS-1$
			return null;
		}
		Shell shell = activeWorkbenchWindow.getShell();
		if (shell == null) {
			LOGGER.log(Level.SEVERE, "[TOOL] There is no shell in the WorkbenchWindow"); //$NON-NLS-1$
			return null;
		}
		if (!MigrationOfferDialog.canDialogBeOpened(PeriphControllerWrapper.getInstance())) {
			MessageDialog.openInformation(shell, Messages.get().OpenMigrationOfferDialogHandler_NotOpeningMessage_Title,
					Messages.get().OpenMigrationOfferDialogHandler_NotOpeningMessage_Description);
			return null;
		}
		// FIXME TomasR v99 - Move to Peripherals tool specific product plugin if required by DDR
		MigrationOfferDialog.open(shell, PeriphControllerWrapper.getInstance(), true);
		return null;
	}
}
