/**
 * Copyright 2018-2021 NXP
 * Created: 8. 2. 2018
 */
package com.nxp.swtools.periphs.gui.handler;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.view.componentsettings.CollapsibleSettingsStorageHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ProvidableSettingsSelectionStorageHelper;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.command.ProcessorResetDialog;
import com.nxp.swtools.utils.command.ProcessorResetDialog.ResetMethod;

/**
 * Handler for reset to processor defaults command (reset currently active/edited function, properties remain)
 * @author Marek Ciz
 */
public class ResetToProcessorDefaultHandler extends AbstractHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		Controller controller = Controller.getInstance();
		IFunctionalGroup functionalGroup = controller.getFunctionalGroup();
		final ProcessorResetDialog dialog = new ProcessorResetDialog(ShellProvider.getAnyShellParent(), functionalGroup.getName(), controller.hasProcessorMex());
		int result = dialog.open();
		if (result == IDialogConstants.OK_ID) {
			if (dialog.getResetMethod() == ResetMethod.MEX_VALUES) {
				resetToProcessorDefaultsSynchronized(functionalGroup.getName(), true);
				controller.resetToProcessorMexDefaults(functionalGroup);
			} else {
				resetToProcessorDefaultsSynchronized(functionalGroup.getName(), false);
				controller.resetToProcessorDefault(functionalGroup);
			}
			CollapsibleSettingsStorageHelper.getInstance().removeSettingStateEntries(functionalGroup.getId());
			ProvidableSettingsSelectionStorageHelper.getInstance().removeSettingStateEntries(functionalGroup.getId());
		}
		return null;
	}

	/**
	 * Method used to restore other functional groups to their default state when functional group synchronization is enabled
	 * @param functionalGroupName - name of the functional group from where reset to default was performed
	 * @param mexDefaults - <code>true</code> if reset to mex defaults should be performed, <code>false</code> if raw reset should be performed
	 */
	private static void resetToProcessorDefaultsSynchronized(String functionalGroupName, boolean mexDefaults) {
		Controller controller = Controller.getInstance();
		PeriphsProfile profile = controller.getProfile();
		if (profile.isFunctionalGroupSynchronizationEnabled()) {
			final List<IFunctionalGroup> fcGroups = new ArrayList<>(profile.getFunctionalGroups());
			for (IFunctionalGroup group : fcGroups) {
				if (!group.getName().equals(functionalGroupName)) {
					if (mexDefaults) {
						controller.resetToProcessorMexDefaults(group);
					} else {
						controller.resetToProcessorDefault(group);
					}
				}
			}
		}
	}
}
