/**
 * Copyright 2019, 2022 NXP
 */
package com.nxp.swtools.periphs.gui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.view.componentsettings.GlobalComponentSettingView;

/**
 * Handler used for opening view with all global config sets
 * @author Tomas Rudolf - nxf31690
 */
public class ShowGlobalConfigsHandler extends AbstractHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
		GlobalComponentSettingView.open(window.getActivePage(), "*", null); //$NON-NLS-1$
		return null;
	}

}
