/**
 * Copyright 2021-2022 NXP
 * Created: Apr 06 2021
 */
package com.nxp.swtools.periphs.gui.templates.component;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplateProperties;
import com.nxp.swtools.utils.TestIDs;

/**
 * Dialog to update details of component template
 * @author Tomas Rudolf - nxf31690
 */
// FIXME TomasR v13 maintenance - Unify common parts with ComponentTemplateCreationDialog
public class ComponentTemplateDetailDialog extends Dialog {
	/** Properties which are displayed */
	private ComponentTemplateProperties properties;
	/** Text-box for name */
	private @Nullable Text nameText;
	/** Text-box for description */
	private @Nullable Text descriptionText;
	/** Result of the dialog */
	private @Nullable ComponentTemplateProperties result;

	/**
	 * Constructor
	 * @param shell in which this dialog will open
	 * @param properties which will be displayed
	 */
	public ComponentTemplateDetailDialog(Shell shell, ComponentTemplateProperties properties) {
		super(shell);
		this.properties = properties;
	}

	/**
	 * Opens this dialog
	 * @param shell in which this dialog will open
	 * @param properties which will be displayed
	 * @return @see {@link Dialog#open()}
	 */
	public static @Nullable ComponentTemplateProperties open(Shell shell, ComponentTemplateProperties properties) {
		ComponentTemplateDetailDialog dialog = new ComponentTemplateDetailDialog(shell, properties);
		dialog.setBlockOnOpen(true);
		dialog.open();
		return dialog.getResult();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.get().ComponentTemplateDetailDialog_Title);
		Shell parentShell = getParentShell();
		if (parentShell != null) {
			int parentShellWidth = parentShell.getSize().x;
			int partOfParentWidth = (int) (parentShellWidth * ComponentTemplateCreationDialog.SHELL_WIDTH_PERCENTAGE);
			int width = Math.max(partOfParentWidth, ComponentTemplateCreationDialog.SHELL_MINIMAL_WIDTH);
			newShell.setSize(width, ComponentTemplateCreationDialog.SHELL_MINIMAL_HEIGHT);
			newShell.setMinimumSize(width, ComponentTemplateCreationDialog.SHELL_MINIMAL_HEIGHT);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		GridLayout layout = new GridLayout(1, false);
		composite.setLayout(layout);
		Composite detailsComposite = new Composite(composite, SWT.NONE);
		GridLayout detailsCompositeLayout = new GridLayout(1, false);
		detailsComposite.setLayout(detailsCompositeLayout);
		detailsComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		Label nameLabel = new Label(detailsComposite, SWT.NONE);
		nameLabel.setText(Messages.get().ComponentTemplateDetailDialog_LabelName);
		nameLabel.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		Text nameTextLoc = new Text(detailsComposite, SWT.BORDER);
		SWTFactoryProxy.INSTANCE.setTestId(nameTextLoc, TestIDs.PERIPHS_TEMPLATE_NAME_TEXT);
		nameText = nameTextLoc;
		nameTextLoc.setText(properties.getName());
		nameTextLoc.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		Label descriptionLabel = new Label(detailsComposite, SWT.NONE);
		descriptionLabel.setText(Messages.get().ComponentTemplateCreationDialog_DescriptionLabelText);
		descriptionLabel.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		Text descriptionTextLoc = new Text(detailsComposite, SWT.BORDER | SWT.MULTI);
		SWTFactoryProxy.INSTANCE.setTestId(descriptionTextLoc, TestIDs.PERIPHS_TEMPLATE_DESCRIPTION_TEXT);
		descriptionText = descriptionTextLoc;
		descriptionTextLoc.setText(properties.getDescription());
		GridData descriptionTextLayoutData = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		descriptionTextLayoutData.heightHint = ComponentTemplateCreationDialog.DESCRIPTION_TEXTBOX_LINES * descriptionTextLoc.getLineHeight();
		descriptionTextLoc.setLayoutData(descriptionTextLayoutData);
		return composite;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	@Override
	protected void okPressed() {
		AvailableComponents availableComponents = Controller.getInstance().getMcu().getAvailableComponents(); // FIXME TomasR v13 maintenance - Replace by controller wrapper which must be provided by current perspective
		Text nameTextLoc = nameText;
		Text descriptionTextLoc = descriptionText;
		if (nameTextLoc != null && descriptionTextLoc != null) {
			setResult(ComponentTemplate.update(properties, nameTextLoc.getText(), descriptionTextLoc.getText(), availableComponents));
		}
		super.okPressed();
	}

	/**
	 * Sets result of this dialog
	 * @param result to be saved
	 */
	private void setResult(@Nullable ComponentTemplateProperties result) {
		this.result = result;
	}

	/**
	 * @return saved result of the dialog
	 */
	private @Nullable ComponentTemplateProperties getResult() {
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#isResizable()
	 */
	@Override
	protected boolean isResizable() {
		return true;
	}
}
