/**
 * Copyright 2022 NXP
 */
package com.nxp.swtools.periphs.gui.view;

import org.eclipse.ui.IViewSite;

import com.nxp.swtools.common.utils.NonNullByDefault;

/**
 * Abstract handler of external views for Peripherals tool
 * @author Tomas Rudolf - nxf31690
 */
@NonNullByDefault
public abstract class APeriphsExternalViewHandler {

	/**
	 * Open the view for given identification
	 * @param viewSite in which the view should open
	 * @param uuid identification for the view
	 */
	public void openViewFor(@SuppressWarnings("unused") IViewSite viewSite, @SuppressWarnings("unused") String uuid) {
		// Implement in sub-class
	}
}
