/**
 * Copyright 2022 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.TestIDs;

/**
 * @author Ionut-Cristian Tudose - nxf64017
 * Class representing common base for ScalarComboControl classes
 */
public abstract class AScalarComboControl extends ScalarControl {

	/**
	 * @param child to create control for
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	public AScalarComboControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(child, controlOptions, controllerWrapper);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		Composite c = createComposite(composite);
		createControls(c);
		addComboSelectionListener();
		addSpecificListeners();
		return c;
	}

	/**
	 * Method used to create the combo box for scalar combo control class
	 * @param composite - in which to create the combo box
	 * @return created combo box
	 */
	protected InstantSearchList createComboBox(@NonNull Composite composite) {
		InstantSearchList comboLoc = new InstantSearchList(composite, getSwtStyle());
		comboLoc.setLayoutData(new GridDataComponents(SWT.FILL, SWT.CENTER, true, false));
		SWTFactoryProxy.INSTANCE.setTestId(comboLoc, TestIDs.PERIPHS_SETTING_CONTROL + child.getId());
		mainControlInternal = comboLoc;
		comboLoc.setData(KEY_INPUT, CollectionsUtils.emptyList());
		createErrorDecoration(comboLoc, SWT.LEFT | SWT.TOP);
		return comboLoc;
	}

	/**
	 * Method used to create composite for the controls of this class
	 * @param composite - parent composite
	 * @return created composite
	 */
	protected abstract @NonNull Composite createComposite(@NonNull Composite composite);

	/**
	 * Method used to create controls for the control
	 * @param composite to create controls in
	 */
	protected abstract void createControls(@NonNull Composite composite);

	/**
	 * Method used to add combo box selection listener to ScalarComboControl
	 */
	protected abstract void addComboSelectionListener();

	/**
	 * Method used to add specific listeners for the controls of the class
	 */
	protected abstract void addSpecificListeners();
}
