/**
 * Copyright 2019-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.periphs.gui.view.APeriphsViewBase;
import com.nxp.swtools.utils.view.ToolView;

/**
 * Base class for editor based views
 * @author Tomas Rudolf - nxf31690
 */
public abstract class EditorViewBase extends APeriphsViewBase {

	/** Content of the editor */
	protected Composite contentComposite;
	/** State of the view - uninitialized by default */
	@NonNull State state = State.UNINITIALIZED;
	
	/**
	 * Enumeration containing possible states of the component setting view.
	 * @author Juraj Ondruska
	 */
	protected enum State {
		/** the view is unitialized (its content has not been created yet) */
		UNINITIALIZED,
		/** the view is unitialized but is ready to be created when it becomes visible */
		READY_TO_CREATE,
		/** the view is initialized but hidden */
		CREATED_HIDDEN,
		/** the view is initialized and visible */
		CREATED_VISIBLE
	}

	@Override
	public void setFocus() {
		Composite composite = contentComposite;
		if ((composite != null) && !composite.isDisposed() && (state == State.CREATED_VISIBLE)) {
			Control focusedControl = composite.getDisplay().getFocusControl();
			if (!(OSDetect.isUnix() && (focusedControl != null) && ToolView.isControlAncestor(focusedControl, composite))) {
				// MCUXCON-2650 On Linux with GTK2 setFocus call, even when select value from combo inside view
				composite.setFocus();
			}
		}
	}

	/**
	 * Enumeration containging required actions of the component setting view.
	 * @author Juraj Ondruska
	 */
	protected enum ActionRequired {
		/** No action required when the view becomes visible */
		NO_ACTION,
		/** Refresh of the view is required when the view becomes visible */
		REFRESH,
		/** Recreate of the view is required when the view becomes visible */
		RECREATE
	}

	/**
	 * @return non null IWorkbenchPartSite - calls {@link #getSite()}e
	 */
	@NonNull
	public IWorkbenchPartSite getSiteSafe() {
		IWorkbenchPartSite site = getSite();
		assert site != null;
		return site;
	}

}