/**
 * Copyright 2020-2021 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.periphs.controller.events.EventTypes;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.SettingOptions;

/**
 * Class representing control of a button setting configuration.
 * @author Iulia Vasii
 */
public class ScalarButtonControl extends ScalarControl {

	/**
	 * @param child to create control for
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	public ScalarButtonControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(child, controlOptions, controllerWrapper);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#create(org.eclipse.swt.widgets.Composite, int)
	 */
	@Override
	public void create(@NonNull Composite composite, int colSpan) {
		super.create(composite, colSpan);
		Control mainControlLoc = mainControl;
		if (mainControlLoc != null) {
			int colSpanLoc = colSpan;
			if (!getControlOptions().isLabelHidden()) {
				colSpanLoc = colSpan - 1;
			}
			mainControlLoc.setLayoutData(new GridDataComponents(SWT.LEFT, SWT.CENTER, true, false, colSpanLoc, 1));
		}
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ScalarControl#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @NonNull Control createMainControl(@NonNull Composite composite) {
		final Composite buttonComposite = new Composite(composite, SWT.NONE);
		GridLayoutComponents buttonCompositeLayout = new GridLayoutComponents();
		buttonCompositeLayout.marginWidth = buttonCompositeLayout.marginHeight = 0;
		buttonComposite.setLayout(buttonCompositeLayout);
		Button button = new Button(buttonComposite, SWT.PUSH);
		button.setLayoutData(new GridDataComponents(SWT.LEFT, SWT.CENTER, true, false));
		mainControlInternal = button;
		button.setText(getChild().getValue().toString());
		button.addSelectionListener(new SelectionAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (getChild().isOptionSet(SettingOptions.UI_OPEN_VIEW)) {
					Object data = getChild().getOptionValue(SettingOptions.UI_OPEN_VIEW);
					IComponentInstanceConfig instance = getChild().getChildContext().getComponentInstanceConfig();
					if ((data instanceof String) && (instance != null)) {
						String viewThatShouldBeOpened = (String) data;
						controllerWrapper.getGUIController().openView(viewThatShouldBeOpened, instance.getUUID(), true);
					}
				}
				Expression exp = getChild().getOnClickExpression();
				if (exp != null) {
					try {
						exp.resolve(getChild().getExpressionContext());
						controllerWrapper.getController().handleSettingChange(EventTypes.SETTING_CHANGE, this, UtilsText.safeString(Messages.get().Controller_Action_SetValueOfSetting), getChild());
					} catch (ExpressionException ex) {
						LOGGER.severe("[DATA] Error while executing action:" + System.lineSeparator() + exp + ex.getMessage()); //$NON-NLS-1$
					}
				}
			}
		});
		createErrorDecoration(button, SWT.LEFT | SWT.TOP);
		return buttonComposite;
	}

}
