/**
 * Copyright 2017-2021 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.SetConfig;

/**
 * Class representing control of a set setting configuration.
 * @author Juraj Ondruska
 */
public class SetControl extends ChildProvidableControlBase {

	/**
	 * @param childProvidable to create control for
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	public SetControl(@NonNull SetConfig childProvidable, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(childProvidable, controlOptions, controllerWrapper);
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		int columnCount = ComponentSettingView.SET_COLS;
		Integer numOfColumns = controlOptions.getNumOfColumns();
		if (numOfColumns != null) {
			columnCount = numOfColumns.intValue();
		}
		final Composite contentCompositeLoc = createComposite(composite, columnCount);
		for (IChildControl childControl : children) {
			childControl.create(contentCompositeLoc, 1);
		}
		return (contentCompositeLoc == composite) ? null : contentCompositeLoc;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createComposite(org.eclipse.swt.widgets.Composite, int)
	 */
	@Override
	public @NonNull Composite createComposite(@NonNull Composite parentComposite, int numColumns) {
		GridLayoutComponents layout = new GridLayoutComponents(numColumns, false);
		if (getControlOptions().isBorderHidden()) {
			layout.marginWidth = 0;
		} else {
			layout.marginWidth = 8;
		}
		int style = getSwtStyle();
		Composite composite = new Composite(parentComposite, style);
		composite.setLayout(layout);
		return composite;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createLabelControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createLabelControl(@NonNull Composite composite) {
		final Control label = super.createLabelControl(composite);
		if (label != null) {
			createErrorDecoration(label, SWT.LEFT | SWT.TOP);
		}
		return label;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#isCollapsible()
	 */
	@Override
	public boolean isCollapsible() {
		return false;
	}
}
