/**
 * Copyright 2017-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.SetConfig.SetPresence;
import com.nxp.swtools.utils.progress.ProgressUtils;

/**
 * Class representing control of a set presence setting configuration.
 * @author Juraj Ondruska
 */
public class SetPresenceControl extends ChildControlBase {

	/**
	 * @param child to create control for
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	public SetPresenceControl(@NonNull SetPresence child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(child, controlOptions, controllerWrapper);
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildControlBase#create(org.eclipse.swt.widgets.Composite, int)
	 */
	@Override
	public void create(@NonNull Composite composite, int colSpan) {
		super.create(composite, colSpan);
		// make checkbox react only when clicked directly on it - don't react when clicked on an empty space next to a checkbox
		if (mainControl != null) {
			mainControl.setLayoutData(new GridDataComponents(SWT.LEFT, SWT.CENTER, true, false, colSpan, 1));
		}
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildControlBase#createLabelControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createLabelControl(@NonNull Composite composite) {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildControlBase#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @NonNull Control createMainControl(@NonNull Composite composite) {
		Button checkbox = new Button(composite, SWT.CHECK);
		checkbox.addSelectionListener(new SelectionAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				final boolean selection = checkbox.getSelection();
				ProgressUtils.run((m) -> {
					controllerWrapper.getController().setSetPresence(getChild(), selection, checkbox);
				});
			}
		});
		return checkbox;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	protected void updateMainContent(@NonNull Control contentControl, UpdateType updateType) {
		if (updateType != UpdateType.PROBLEM_DECORATION) {
			Button button = (Button) contentControl;
			button.setText(child.getUiName());
			button.setSelection(getChild().getBoolValue());
			button.requestLayout();
		}
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.editor.ChildControlBase#getChild()
	 */
	@Override
	public @NonNull SetPresence getChild() {
		return (SetPresence) child;
	}

}
