/**
 * Copyright 2017-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.data.SettingOptions;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.StructSetting;
import com.nxp.swtools.resourcetables.model.data.setting.VariableSetting;

/**
 * Factory of the {@link AArrayControlInternal} implementations.
 * @author Juraj Ondruska
 */
public class ArrayControlInternalFactory {

	/**
	 * Create proper {@link AArrayControlInternal} for the array configuration given its options.
	 * {@link SettingOptions#UI_ARRAY_LAYOUT_HORIZONTAL} and {@link SettingOptions#SHOW_CONTENT_AS} are considered.
	 * @param arrayConfig for which to create the GUI
	 * @param controlOptions for new control
	 * @param controllerWrapper containing the generic controller
	 * @return implementation of an {@link AArrayControlInternal}
	 */
	public static @NonNull AArrayControlInternal create(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions,
			@NonNull IControllerWrapper controllerWrapper) {
		ISetting arrayTypeSeting = arrayConfig.getInstanceSetting();
		if (arrayTypeSeting instanceof VariableSetting) {
			return new ArrayControlInvisible(arrayConfig, controlOptions, controllerWrapper);
		}
		if (arrayTypeSeting instanceof StructSetting) {
			boolean invisible = true;
			StructSetting structSetting = (StructSetting) arrayTypeSeting;
			for (ISetting setting : structSetting.getSettings().values()) {
				if (!(setting instanceof VariableSetting)) {
					invisible = false;
					break;
				}
			}
			if (invisible) {
				return new ArrayControlInvisible(arrayConfig, controlOptions, controllerWrapper);
			}
		}
		switch (arrayConfig.getRepresentation()) {
			case VERTICAL_TABLE:
				return new ArrayControlTabularVertical(arrayConfig, controlOptions, controllerWrapper);
			case HORIZONTAL_TABLE:
				return new ArrayControlTabularHorizontal(arrayConfig, controlOptions, controllerWrapper);
			case VERTICAL_RADIOS:
				return new ArrayControlRadioVertical(arrayConfig, controlOptions, controllerWrapper);
			case HORIZONTAL_RADIOS:
				return new ArrayControlRadioHorizontal(arrayConfig, controlOptions, controllerWrapper);
			case MASTER_DETAIL:
				return new ArrayControlMasterDetail(arrayConfig, controlOptions, controllerWrapper);
			case TABS:
				return new ArrayControlTabs(arrayConfig, controlOptions, controllerWrapper);
			case HORIZONTAL_FORM:
				return new ArrayControlStandardHorizontal(arrayConfig, controlOptions, controllerWrapper);
			default:
			case VERTICAL_FORM:
				return new ArrayControlStandardVertical(arrayConfig, controlOptions, controllerWrapper);
		}
	}
}
