/**
 * Copyright 2019-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import java.util.Iterator;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;

/**
 * Invisible array with invisible items that can still hold constraints and dependencies
 * @author Tomas Rudolf - nxf31690
 */
public class ArrayControlInvisible extends AArrayControlInternal {

	/**
	 * Constructor
	 * @param arrayConfig to use as model
	 * @param controlOptions for this control
	 * @param controllerWrapper containing controller that manages given config
	 */
	protected ArrayControlInvisible(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(arrayConfig, controlOptions, controllerWrapper);
	}

	@Override
	public @Nullable Control createLabelControl(@NonNull Composite composite) {
		return null;
	}

	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		return null;
	}

	@Override
	public void update(@NonNull UpdateType updateType) {
		super.update(updateType);
		Iterator<ISettingConfig> arrayItemIterator = arrayConfig.getChildren().iterator();
		ISettingConfig arrayItem = arrayItemIterator.hasNext() ? arrayItemIterator.next() : null;
		while (arrayItem != null) {
			// This should trigger problems generation
			ToolTipableFormatter.getToolTipText(arrayItem);
			arrayItem = arrayItemIterator.hasNext() ? arrayItemIterator.next() : null;
		}
	}

	@Override
	public void updateMainContent(@NonNull Control mainControlLoc, @NonNull UpdateType updateType) {
		// Not supported
	}

	@Override
	protected void updateButtons(@Nullable UpdateType updateType) {
		// Not supported
	}

	@Override
	public void setAllSettingsTo(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
		// Not supported
	}

}
