/**
* Copyright 2018-2021 NXP
* Created: Feb 9, 2018
*/
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType;
import com.nxp.swtools.resourcetables.model.config.IChild;

/**
 * A table context for item menus in {@link ArrayControl} 
 * @author Viktar Paklonski
 */
public class ArrayControlItemMenuContext implements IArrayControlItemMenuControl {
	/** instance owner */
	protected final @NonNull AArrayControlGroup owner;
	/** pop-up menu */
	protected final @NonNull ArrayControlItemMenu menu;
	/** last setting control for which the menu was shown (single array item) */
	protected @Nullable IChildControl selectedItemHint;
	/** last setting for which the menu was shown (exact setting of an array item) */
	protected @Nullable IChild selectedSettingHint;

	/**
	 * Prepares menu context for the specified widget.
	 * @param owner of the instance
	 * @param viewer of the table to manipulate content in
	 */
	public ArrayControlItemMenuContext(@NonNull AArrayControlGroup owner, @NonNull TableViewer viewer) {
		this.owner = owner;
		final Table table = viewer.getTable();
		assert table != null;
		menu = new ArrayControlItemMenu(owner, this, table);
		table.setMenu(menu.getMenu());
		table.addListener(SWT.MenuDetect, new Listener() {
			@Override
			public void handleEvent(Event event) {
				final TableItem[] selection = table.getSelection();
				if (selection.length != 0) {
					assert selection.length == 1;
					final Object element = viewer.getElementAt(table.getSelectionIndex());
					if (element != null) {
						if (element instanceof IChildControl) {
							selectedItemHint = (IChildControl) element;
						}
						if (selectedItemHint == null) {
							event.doit = false;  // do not show menu when no item is selected
						} else {
							menu.fillManager(UpdateType.NORMAL);
						}
					}
				} else {
					event.doit = false;  // do not show menu when no item is selected
				}
			}
		});
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl#dispose()
	 */
	@Override
	public void dispose() {
		menu.dispose();
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl#getMenu()
	 */
	@Override
	public @NonNull Menu getMenu() {
		return menu.getMenu();
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl#getSelectedSettingHint()
	 */
	@Override
	public @Nullable IChildControl getSelectedItemHint() {
		return selectedItemHint;
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl#getSelectedSettingHint()
	 */
	@Override
	public @Nullable IChild getSelectedSettingHint() {
		return selectedSettingHint;
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl#update(com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	public void update(@Nullable UpdateType updateType) {
		menu.fillManager(updateType);
	}
}
