/**
* Copyright 2018-2019, 2021 NXP
* Created: Feb 20, 2018
*/
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType;

/**
 * A horizontally-oriented table context for item menus in {@link ArrayControl} 
 * @author Viktar Paklonski
 */
public class ArrayControlItemMenuContextHorizontal extends ArrayControlItemMenuContext {

	/** Count of rows that must be offset in calculations with position of selected item */
	private static final int OFFSET_DECORATOR_ROWS = 1;

	/**
	 * Prepares menu context for the specified widget.
	 * @param owner of the instance
	 * @param viewer of the table to manipulate content in
	 */
	public ArrayControlItemMenuContextHorizontal(@NonNull AArrayControlTabular owner, @NonNull TableViewer viewer) {
		super(owner, viewer);
		final Table table = viewer.getTable();
		assert table != null;
		table.addListener(SWT.MouseDown, new Listener() {
			@Override
			public void handleEvent(Event event) {
				final TableItem[] selection = table.getSelection();
				selectedItemHint = null;
				selectedSettingHint = null;
				if (selection.length != 0) {
					final Point pt = new Point(event.x, event.y);
					final TableItem item = table.getItem(pt);
					if (item != null) {
						final int firstSettingColumn = table.getColumnCount() - owner.getChildren().size();
						assert firstSettingColumn >= 0;
						for (int col = firstSettingColumn; col < table.getColumnCount(); ++col) {
							final Rectangle bounds = item.getBounds(col);
							if (bounds.contains(pt)) {
								selectedSettingHint = owner.getSettingAt(col - firstSettingColumn, table.indexOf(item) - OFFSET_DECORATOR_ROWS);
								final ViewerCell cell = viewer.getCell(pt);
								if (cell != null) {
									final Object element = cell.getElement();
									if (element != null) {
										if (element instanceof TabularHorizontalItem) {
											selectedItemHint = owner.getChildren().get(col - firstSettingColumn);
											menu.fillManager(UpdateType.NORMAL);
										}
									}
								}
								break;
							}
						}
					}
				}
			}
		});
	}
}
