/**
 * Copyright 2018, 2021-2022 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType;

/**
 * A vertically-oriented table context for item menus in {@link ArrayControl}. 
 * @author Juraj Ondruska
 */
public class ArrayControlItemMenuContextVertical extends ArrayControlItemMenuContext {

	/**
	 * Prepares menu context for the specified widget.
	 * @param owner of the instance
	 * @param viewer of the table to manipulate content in
	 */
	public ArrayControlItemMenuContextVertical(@NonNull AArrayControlTabular owner, @NonNull TableViewer viewer) {
		super(owner, viewer);
		final Table table = viewer.getTable();
		assert table != null;
		table.addListener(SWT.MouseDown, new Listener() {
			@Override
			public void handleEvent(Event event) {
				final TableItem[] selection = table.getSelection();
				selectedItemHint = null;
				selectedSettingHint = null;
				if (selection.length != 0) {
					final Point pt = new Point(event.x, event.y);
					final TableItem item = table.getItem(pt);
					if (item != null) {
						IChildControl control = owner.getChildren().get(table.indexOf(item));
						selectedItemHint = control;
						int fstCol = table.getColumnCount() - AArrayControlTabular.getSettingsFlatVisible(control.getChild()).size();
						for (int col = 0; col < table.getColumnCount(); ++col) {
							final Rectangle bounds = item.getBounds(col);
							if (bounds.contains(pt)) {
								int itemInRowIndex = col - fstCol;
								if (col < fstCol ) {
									itemInRowIndex = AArrayControlTabular.INDEX_FOR_RETURNING_THE_ITEMS_SETTING;
								}
								selectedSettingHint = owner.getSettingAt(table.indexOf(item), itemInRowIndex);
								menu.fillManager(UpdateType.NORMAL);
								break;
							}
						}
					}
				}
			}
		});
	}

}
