/**
 * Copyright 2019-2020 NXP
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import java.util.Iterator;

import org.eclipse.swt.widgets.Composite;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions.ShowContentAs;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;

/**
 * Class represents array of radio button groups. Usable only for enum, boolean or structure of enums or booleans
 * @author Tomas Rudolf
 */
public class ArrayControlRadioHorizontal extends ArrayControlRadio {

	/**
	 * Constructor.
	 * @param arrayConfig for which to create the GUI
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	protected ArrayControlRadioHorizontal(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(arrayConfig, controlOptions, controllerWrapper);
	}

	@Override
	protected void createContent(@NonNull Composite contentCompositeLoc) {
		// Show GUI
		for (IChildControl childControl : children) {
			childControl.create(contentCompositeLoc, 1);
		}
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlRadio#updateMainCommonImpl(com.nxp.swtools.periphs.gui.view.
	 * componentsettings.IChildControl.UpdateType, org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected boolean updateMainCommonImpl(@NonNull UpdateType updateType, @NonNull Composite composite) {
		boolean layoutChanged = false;
		Iterator<@NonNull IChildControl> childrenIterator = children.iterator();
		Iterator<@NonNull ISettingConfig> arrayItemsIterator = getChild().getChildren().iterator();
		@Nullable ISettingConfig arrayItem = arrayItemsIterator.hasNext() ? arrayItemsIterator.next() : null;
		// dispose controls of all removed items
		while (childrenIterator.hasNext()) {
			@SuppressWarnings("null") // For static analysis purpose only! Entry is always non-null or exception is thrown
			IChildControl childControl = childrenIterator.next();
			if (!childControl.getChild().equals(arrayItem)) {
				childControl.dispose();
				layoutChanged = true;
			} else { // match
				arrayItem = arrayItemsIterator.hasNext() ? arrayItemsIterator.next() : null;
			}
		}
		// add newly added items to the GUI
		while (arrayItem != null) {
			IChildControl currentChildControl = ChildControlFactory.create(arrayItem, createControlOptionsForChild(arrayItem), controllerWrapper);
			if (currentChildControl != null) {
				children.add(currentChildControl);
				currentChildControl.create(composite, 1);
				layoutChanged = true;
			}
			arrayItem = arrayItemsIterator.hasNext() ? arrayItemsIterator.next() : null;
		}
		// Update container composite to have columns for all children
		((GridLayoutComponents) composite.getLayout()).numColumns = getColumnCount();
		return layoutChanged;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createControlOptionsForChild(com.nxp.swtools.periphs.model.config.IChild)
	 */
	@Override
	protected @NonNull ControlOptions createControlOptionsForChild(@NonNull IChild subChild) {
		ControlOptions overrideOptions = new ControlOptions();
		overrideOptions.showContentAs(ShowContentAs.RADIO_GROUP);
		overrideOptions.labelHidden(true);
		overrideOptions.radioGroupIndicesHidden(false);
		overrideOptions.radioGroupValueLabelHidden(!subChild.getName().equals(ID_ZERO));
		return overrideOptions;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlRadio#createAnotherControl()
	 */
	@Override
	protected ArrayControlRadio createAnotherControl() {
		return new ArrayControlRadioHorizontal(getChild(), getControlOptions(), getControllerWrapper());
	}
}
