/**
 * Copyright 2017-2018 NXP
 */
package com.nxp.swtools.periphs.gui.view.provider;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;

/**
 * Interface adding method canHandle into {@link IProblemResolveHandler}.
 * @author Juraj Ondruska
 */
public interface IPeripheralsProblemResolveHandler extends IProblemResolveHandler {
	/**
	 * Check whether the handler can handle given problem.
	 * @param problem to handle
	 * @return {@code true} if the problem can be handled by the resolver, {@code false} otherwise
	 */
	boolean canHandle(@NonNull IBaseProblem problem);
}
