/**
 * Copyright 2017-2018 NXP
 * Created: Aug 18, 2017
 */ 
package com.nxp.swtools.periphs.gui.wizard;

import java.util.HashMap;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.report.PeriphsHtmlReportGenerator;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.utils.wizards.exportWizard.AExportHtmlWizard;

/**
 * Export HTML report wizard for peripherals tool
 * @author Tomas Rudolf - nxf31690
 */
public class PeriphsExportHTMLReport extends AExportHtmlWizard {

	/**
	 * Constructor
	 */
	public PeriphsExportHTMLReport() {
		super(UtilsText.safeString(Messages.get().PeriphsExportHTMLWizard_Title), PeriphsHtmlReportGenerator.getHtmlFileName(), SwToolsProduct.PRODUCT_ID_PERIPHERALS_TOOL);
	}

	@Override
	public GenerationResult generateFiles() {
		return generateReport();
	}

	/**
	 * Generate report from current profile
	 * @return generated report
	 */
	public static @NonNull GenerationResult generateReport() {
		String toolError = Controller.getInstance().getToolError();
		if (toolError != null) {
			return GenerationResult.fail(toolError);
		} else {
			@NonNull HashMap<@NonNull String, @NonNull String> map = new HashMap<>();
			map.put(PeriphsHtmlReportGenerator.getHtmlFileName(), PeriphsHtmlReportGenerator.generateHtml());
			return GenerationResult.success(map);
		}
	}
}
