/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core.operations;

import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMessages;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import com.nxp.s32ds.rcp.modular.internal.core.ModularOperationStatusImpl;
import com.nxp.s32ds.rcp.modular.internal.core.ModularUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.RemedyConfig;

public abstract class ModularOperation {
    private static final String HTTPS_SCHEME = "https";
    private final ProvisioningSession provisioningSession;
    private String profileId = "_SELF_";
    private final ModularMetaModelReader metaModelReader;
    private ProvisioningContext context;

    public ModularOperation(ProvisioningSession provisioningSession, ModularMetaModelReader metaModelReader) {
        this.provisioningSession = provisioningSession;
        this.metaModelReader = metaModelReader;
        this.context = new ProvisioningContext(provisioningSession.getProvisioningAgent());
    }

    public IStatus executeOperation(ProfileChangeOperation operation, IProgressMonitor progressMonitor) {
        return operation.getProvisioningJob(progressMonitor).run(progressMonitor);
    }

    abstract ProfileChangeOperation getProfileChangeOperation(Collection<IInstallableUnit> var1, String var2, ProvisioningSession var3);

    protected ProvisioningContext getProvisioningContext() {
        return this.context;
    }

    private static void computeRemediationOperation(RemediationOperation remediateOperation, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)ModularMessages.InstallJobCreater_ComputeRemediationOperation, (int)RemedyConfig.getAllRemedyConfigs().length);
        monitor.setTaskName(ModularMessages.InstallJobCreater_ComputeRemediationOperation);
        remediateOperation.resolveModal((IProgressMonitor)subMonitor);
    }

    abstract ModularOperationStatus computeOperation(Set<ModularPack> var1, IProgressMonitor var2);

    protected ModularOperationStatus computeModularOperation(Collection<IInstallableUnit> units, Set<ModularPack> modularObjects, IProgressMonitor progressMonitor) throws ProvisionException {
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        ProvisioningContext provisioningContext = this.getProvisioningContext();
        URI[] uris = modularObjects.stream().map(ModularObject::getUri).distinct().collect(Collectors.toList()).toArray(new URI[0]);
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.rcp.modular.core");
        boolean overlapHttp = node.getBoolean("overlapHttp", false);
        if (overlapHttp) {
            int i = 0;
            while (i < uris.length) {
                if (uris[i] != null) {
                    try {
                        uris[i] = new URI(HTTPS_SCHEME, uris[i].getHost(), uris[i].getPath(), uris[i].getFragment());
                    }
                    catch (URISyntaxException e) {
                        ModularInstallerActivator.getInstance().logError(e.getMessage());
                    }
                }
                ++i;
            }
        }
        provisioningContext.setArtifactRepositories(uris);
        provisioningContext.setMetadataRepositories(uris);
        ProfileChangeOperation profileChangeOperation = null;
        RemediationOperation remediationOperation = null;
        if (!units.isEmpty()) {
            block13: {
                profileChangeOperation = this.getProfileChangeOperation(units, this.getProfileId(), this.getProvisioningSession());
                if (this.getProvisioningSession().hasScheduledOperationsFor(this.getProfileId())) {
                    return new ModularOperationStatusImpl((IStatus)new Status(4, ModularInstallerActivator.getContext().getBundle().getSymbolicName(), ModularMessages.InstallJobCreater_Operation_Already_In_Progress), profileChangeOperation, null, modularObjects, this.getProvisioningSession());
                }
                profileChangeOperation.setProvisioningContext(provisioningContext);
                try {
                    try {
                        if (ModularUtils.shouldRemediate(profileChangeOperation.resolveModal((IProgressMonitor)convert.split(50)))) {
                            remediationOperation = new RemediationOperation(this.provisioningSession, profileChangeOperation.getProfileChangeRequest());
                            remediationOperation.setProvisioningContext(provisioningContext);
                            ModularOperation.computeRemediationOperation(remediationOperation, (IProgressMonitor)convert.split(50));
                        }
                    }
                    catch (NullPointerException e) {
                        ModularInstallerActivator.getInstance().logError("Unexpected NPE from p2 ProfileChangeOperation.resolveModal()", e);
                        convert.done();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    convert.done();
                    throw throwable;
                }
                convert.done();
            }
            IStatus resolutionResult = profileChangeOperation.getResolutionResult();
            return new ModularOperationStatusImpl(resolutionResult, profileChangeOperation, remediationOperation, modularObjects, this.getProvisioningSession());
        }
        throw new ProvisionException((IStatus)new Status(4, ModularInstallerActivator.getContext().getBundle().getSymbolicName(), ModularMessages.InstallJobCreater_NoUnitsToInstall));
    }

    protected ProvisioningSession getProvisioningSession() {
        return this.provisioningSession;
    }

    protected String getProfileId() {
        return this.profileId;
    }

    protected ModularMetaModelReader getModularMetaModelReader() {
        return this.metaModelReader;
    }
}

