/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.cmsis.bsp;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.files.XmlDomProvider;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.sdkproject.cmsis.bsp.PdscExample;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PdscParser {
    protected static final Logger LOGGER = LogManager.getLogger(PdscParser.class);
    private static final String PDSC_EXTENSION = "pdsc";
    private static final List<String> supportedToolchains = new ArrayList<String>(Arrays.asList("uv", "iar"));
    private File pdscFile;
    private Element rootElement;

    private PdscParser(File pdscFile, Element rootElement) {
        this.pdscFile = pdscFile;
        this.rootElement = rootElement;
    }

    public static @Nullable PdscParser findPdsc(String workspace) {
        Collection pdscList;
        File pdsc;
        File workspaceFile = new File(workspace);
        if (workspaceFile.isDirectory() && (pdsc = (File)CollectionsUtils.firstOrNull((Collection)(pdscList = UtilsFile.getAllFilesInDir((File)workspaceFile, (boolean)false, (String)PDSC_EXTENSION)))) != null) {
            Document doc;
            if (pdscList.size() > 1) {
                LOGGER.warning(MessageFormat.format("Use file {0}, but directory contains more files: {1} ", pdsc.getPath(), CollectionsUtils.formatList((Collection)pdscList, (String)", ", File::getPath)));
            }
            if ((doc = XmlDomProvider.getAsW3CDom((String)pdsc.getAbsolutePath(), null)) != null) {
                Element root = doc.getDocumentElement();
                assert (root != null);
                return new PdscParser(pdsc, root);
            }
            LOGGER.severe("Failed to read XML file: " + pdsc.getAbsolutePath());
        }
        return null;
    }

    protected @Nullable PdscExample loadExample(Element example) {
        String name = example.getAttribute("name");
        String foldler = example.getAttribute("folder");
        Element prj = UtilsXmlDom.getChildElement((Element)example, (String)"project");
        if (prj != null) {
            ArrayList<Path> projectPaths = new ArrayList<Path>();
            for (Element env : UtilsXmlDom.getChildrenElements((Element)prj, (String)"environment")) {
                String toolchainName = env.getAttribute("name");
                if (!supportedToolchains.contains(toolchainName)) {
                    LOGGER.info(MessageFormat.format("In example \"{0}\" skip unsupported environment \"{1}\"", name, toolchainName));
                    continue;
                }
                String prjPath = env.getAttribute("load");
                if (prjPath.isEmpty()) continue;
                Path pathToPrjFile = Paths.get(foldler, prjPath);
                Path pathToPrj = pathToPrjFile.getParent();
                if (pathToPrj != null) {
                    projectPaths.add(pathToPrj);
                    continue;
                }
                LOGGER.severe(MessageFormat.format("Unable to get project folder path from load attribute value \"{0}\" for example \"{1}\" from file {2}", prjPath, name, this.pdscFile.getAbsolutePath()));
            }
            if (!projectPaths.isEmpty()) {
                return new PdscExample(name, foldler, projectPaths);
            }
            LOGGER.severe(MessageFormat.format("No project path loaded for example \"{0}\" from file {2}", name, this.pdscFile.getAbsolutePath()));
        }
        return null;
    }

    public List<PdscExample> getExamples() {
        Element examplesElm = UtilsXmlDom.getChildElement((Element)this.rootElement, (String)"examples");
        if (examplesElm == null) {
            LOGGER.severe(MessageFormat.format("No example found in {0}", this.pdscFile.getPath()));
            return Collections.emptyList();
        }
        ArrayList<PdscExample> result = new ArrayList<PdscExample>();
        for (Element example : UtilsXmlDom.getChildrenElements((Element)examplesElm, (String)"example")) {
            PdscExample exam = this.loadExample(example);
            if (exam == null) continue;
            result.add(exam);
        }
        return result;
    }
}

