/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.parsers.ArmGccModernFormatPrjAdapter;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArmGccModernFormatAllLibPrjAdapter
extends ArmGccModernFormatPrjAdapter {
    public static final String CONFIG_CMAKE_WITH_EXT = "config.cmake";
    static final Pattern USED_COMPONENT_CMAKE_PATTERN = Pattern.compile("SET\\(CONFIG_USE_(.+) TRUE\\)", 2);
    static final Predicate<String> ALL_LIB_CMAKE_PREDICATE = Pattern.compile("all_lib_.*.cmake", 2).asPredicate();
    static final String INCLUDE_IF_USE = "INCLUDE_IF_USE(";
    private Collection<@NonNull String> usedComponentCmakes = new HashSet<String>();

    public ArmGccModernFormatAllLibPrjAdapter(@NonNull File file, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(file, prjDir, existingProcessorDetector);
    }

    @Override
    protected @Nullable Collection<@NonNull Path> parseLine(@NonNull String line, @NonNull ArmGccModernFormatPrjAdapter.MacroPathResolver macroPathResolver, @NonNull File file, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, @NonNull IProgressMonitor monitor, boolean parseIncludedCmakes) {
        Collection<@NonNull Path> collector = super.parseLine(line, macroPathResolver, file, prjSources, inclPaths, monitor, parseIncludedCmakes);
        if (collector == null) {
            String lineUppercase = line.toUpperCase(Locale.ENGLISH);
            Matcher matcher = null;
            if (ArmGccModernFormatAllLibPrjAdapter.isLineStartAndEndWith(lineUppercase, INCLUDE_IF_USE, ")")) {
                String includeCmakeWithoutMcuSuffix;
                String includeCmake = ArmGccModernFormatAllLibPrjAdapter.getCommandSingleLineText(line, INCLUDE_IF_USE.length());
                int dotIndex = includeCmake.lastIndexOf(".");
                String string = includeCmakeWithoutMcuSuffix = dotIndex > 0 ? includeCmake.substring(0, dotIndex) : includeCmake;
                if (this.usedComponentCmakes.contains(includeCmakeWithoutMcuSuffix)) {
                    this.processIncludeCmake(includeCmake, macroPathResolver, file, prjSources, inclPaths, monitor);
                }
            } else {
                if (lineUppercase.startsWith("LIST(APPEND CMAKE_MODULE_PATH")) {
                    return this.cmakeModulePaths;
                }
                matcher = USED_COMPONENT_CMAKE_PATTERN.matcher(line);
                if (matcher.find()) {
                    String comp = matcher.group(1);
                    assert (comp != null) : "Used component not found in line:" + line;
                    this.usedComponentCmakes.add(comp);
                }
            }
        }
        return collector;
    }

    @Override
    public @NonNull Set<Path> getAdditionalPrjFilePathsToWatch() {
        HashSet<Path> set = new HashSet<Path>(super.getAdditionalPrjFilePathsToWatch());
        set.add(this.getProjectRootPath().resolve(CONFIG_CMAKE_WITH_EXT));
        return set;
    }
}

