/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.ArmGccPrjAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Version;

@NonNullByDefault
public class ArmGccModernFormatPrjAdapter
extends ArmGccPrjAdapter {
    public static final String FLAGS_CMAKE = "flags";
    public static final String FLAGS_CMAKE_WITH_EXT = "flags.cmake";
    public static final String OPTIONAL_INCLUDE = " OPTIONAL";
    private static final String MEMBERS_REGEX = "(PUBLIC)|(PRIVATE)";
    protected HashMap<@NonNull File, @NonNull Boolean> includedCmake = new HashMap();
    protected Collection<@NonNull Path> cmakeModulePaths = new HashSet<Path>();
    public static final String VARIABLE_CMAKE_FORMAT_VERSION_MAJOR = "SET(MCUXPRESSO_CMAKE_FORMAT_MAJOR_VERSION ";
    public static final String VARIABLE_CMAKE_FORMAT_VERSION_MINOR = "SET(MCUXPRESSO_CMAKE_FORMAT_MINOR_VERSION ";
    public static final String VARIABLE_CMAKE_FORMAT_VERSION_MAJOR_ALTR = "SET (MCUXPRESSO_CMAKE_FORMAT_MAJOR_VERSION ";
    public static final String VARIABLE_CMAKE_FORMAT_VERSION_MINOR_ALTR = "SET (MCUXPRESSO_CMAKE_FORMAT_MINOR_VERSION ";

    public static @Nullable Version getCmakeFormatVersion(File file) {
        String major = null;
        String minor = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII));){
                String line;
                while ((line = reader.readLine()) != null && (Objects.isNull(major) || Objects.isNull(minor))) {
                    String lineUppercase = line.toUpperCase(Locale.ENGLISH).trim();
                    if (lineUppercase.startsWith(VARIABLE_CMAKE_FORMAT_VERSION_MAJOR)) {
                        major = ArmGccModernFormatPrjAdapter.getCommandSingleLineText(line, VARIABLE_CMAKE_FORMAT_VERSION_MAJOR.length());
                        continue;
                    }
                    if (lineUppercase.startsWith(VARIABLE_CMAKE_FORMAT_VERSION_MINOR)) {
                        minor = ArmGccModernFormatPrjAdapter.getCommandSingleLineText(line, VARIABLE_CMAKE_FORMAT_VERSION_MINOR.length());
                        continue;
                    }
                    if (lineUppercase.startsWith(VARIABLE_CMAKE_FORMAT_VERSION_MAJOR_ALTR)) {
                        major = ArmGccModernFormatPrjAdapter.getCommandSingleLineText(line, VARIABLE_CMAKE_FORMAT_VERSION_MAJOR_ALTR.length());
                        continue;
                    }
                    if (!lineUppercase.startsWith(VARIABLE_CMAKE_FORMAT_VERSION_MINOR_ALTR)) continue;
                    minor = ArmGccModernFormatPrjAdapter.getCommandSingleLineText(line, VARIABLE_CMAKE_FORMAT_VERSION_MINOR_ALTR.length());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            assert (false);
        }
        catch (IOException iOException) {}
        if (major != null && minor != null) {
            return new Version(Integer.parseInt(major), Integer.parseInt(minor), 0);
        }
        return new Version(1, 0, 0);
    }

    static boolean isLineStartAndEndWith(String line, String startWith, String endWith) {
        return line.startsWith(startWith) && line.endsWith(endWith);
    }

    static String getCommandSingleLineText(String line, int startText) {
        return line.substring(startText, line.length() - 1);
    }

    public ArmGccModernFormatPrjAdapter(File file, File prjDir, IToolchainProjectWithSdk existingProcessorDetector) {
        super(file, prjDir, existingProcessorDetector);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean parse(@NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, @NonNull IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
        boolean parseResults = this.parseFile(this.prjFile, prjSources, inclPaths, monitor, true);
        subMon.done();
        Predicate<@Nullable Boolean> succesfullyParse = Boolean.TRUE::equals;
        return parseResults && this.includedCmake.values().stream().allMatch(succesfullyParse);
    }

    boolean parseFile(File file, Set<@NonNull Path> prjSources, List<@NonNull Path> inclPaths, IProgressMonitor monitor, boolean parseIncludedCmakes) {
        MacroPathResolver macroPathResolver = new MacroPathResolver(file, this.prjPath);
        return this.parseFile(file, macroPathResolver, prjSources, inclPaths, monitor, parseIncludedCmakes);
    }

    private boolean parseFile(File file, MacroPathResolver macroPathResolver, Set<@NonNull Path> prjSources, List<@NonNull Path> inclPaths, IProgressMonitor monitor, boolean parseIncludedCmakes) {
        Collection<Path> setToCollectPath = null;
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII));){
                String line;
                while ((line = reader.readLine()) != null) {
                    line = line.replaceAll(MEMBERS_REGEX, "");
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (setToCollectPath != null) {
                        Collection<@NonNull Path> paths = macroPathResolver.getMultiLinePath(line);
                        if (paths != null) {
                            setToCollectPath.addAll(paths);
                            continue;
                        }
                        setToCollectPath = null;
                        continue;
                    }
                    setToCollectPath = this.parseLine(line, macroPathResolver, file, prjSources, inclPaths, monitor, parseIncludedCmakes);
                }
                monitor.worked(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.severe("Failed to parse cMake file, file does not exist:" + file);
            return false;
        }
        catch (IOException iOException) {}
        assert (setToCollectPath == null) : "Collecting multiline path was not correctly ended in " + file.getName();
        return true;
    }

    protected @Nullable Collection<Path> parseLine(String line, MacroPathResolver macroPathResolver, File file, Set<Path> prjSources, List<Path> inclPaths, IProgressMonitor monitor, boolean parseIncludedCmakes) {
        String lineUppercase = line.toUpperCase(Locale.ENGLISH);
        if (ArmGccModernFormatPrjAdapter.isLineStartAndEndWith(lineUppercase, "PROJECT(", ")")) {
            this.detectedProjectName = UtilsFile.getFileNameWithoutExtension((String)ArmGccModernFormatPrjAdapter.getCommandSingleLineText(line, 8));
        } else {
            if (lineUppercase.startsWith("ADD_EXECUTABLE(") || lineUppercase.startsWith("ADD_LIBRARY(") || lineUppercase.startsWith("TARGET_SOURCES(")) {
                return prjSources;
            }
            if (lineUppercase.startsWith("TARGET_INCLUDE_DIRECTORIES(")) {
                return inclPaths;
            }
            if (lineUppercase.startsWith("INCLUDE(") && line.endsWith(")")) {
                if (!parseIncludedCmakes) {
                    return null;
                }
                String includeCmake = ArmGccModernFormatPrjAdapter.getCommandSingleLineText(line, 8);
                this.processIncludeCmake(includeCmake, macroPathResolver, file, prjSources, inclPaths, monitor);
            } else {
                if (lineUppercase.startsWith("SET(CMAKE_MODULE_PATH")) {
                    return this.cmakeModulePaths;
                }
                if (lineUppercase.startsWith("SET(")) {
                    return macroPathResolver.addMacroDefinition(line.substring(4));
                }
            }
        }
        return null;
    }

    protected void processIncludeCmake(String cmakeName, MacroPathResolver macroPathResolver, File file, Set<Path> prjSources, List<Path> inclPaths, IProgressMonitor monitor) {
        File cmakeFile;
        boolean optionalFile = cmakeName.endsWith(OPTIONAL_INCLUDE);
        if (optionalFile) {
            cmakeName = cmakeName.substring(0, cmakeName.length() - OPTIONAL_INCLUDE.length());
        }
        if (cmakeName.endsWith(".cmake")) {
            Collection<@NonNull Path> path = macroPathResolver.getSingleLinePath(cmakeName);
            assert (path != null && path.size() == 1);
            cmakeFile = macroPathResolver.resolveRelativePath((Path)CollectionsUtils.first(path)).toFile();
        } else {
            assert (!this.cmakeModulePaths.isEmpty());
            String includeCmakeWithExt = String.valueOf(cmakeName) + ".cmake";
            cmakeFile = (File)CollectionsUtils.findAny(this.cmakeModulePaths.stream().map(mPath -> macroPathResolver.resolveRelativePath((Path)mPath).resolve(includeCmakeWithExt).toFile()), File::exists);
            if (cmakeFile == null) {
                LOGGER.severe(String.format("[SDK/SDKGEN] Not found make file '%s', that was included from '%s'", cmakeName, file));
                return;
            }
        }
        if (!this.includedCmake.containsKey(cmakeFile)) {
            this.includedCmake.put(cmakeFile, Boolean.FALSE);
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
            boolean parseResult = false;
            if (FLAGS_CMAKE_WITH_EXT.equals(cmakeFile.getName())) {
                parseResult = this.parseFlags(cmakeFile, (IProgressMonitor)subMon);
            } else if (!cmakeFile.exists()) {
                parseResult = optionalFile;
            } else {
                MacroPathResolver cmakeMacroPathResolver = new MacroPathResolver(cmakeFile, this.prjPath);
                parseResult = this.parseFile(cmakeFile, cmakeMacroPathResolver, prjSources, inclPaths, (IProgressMonitor)subMon, false);
                macroPathResolver.addAllMacros(cmakeMacroPathResolver);
            }
            this.includedCmake.put(cmakeFile, parseResult);
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean parseFlags(File file, IProgressMonitor monitor) {
        succesfulParse = (BooleanSupplier)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$3(), ()Z)((ArmGccModernFormatPrjAdapter)this);
        try {
            var4_4 = null;
            var5_6 = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII));
                try {
                    insideCFlags = false;
                    if (true) ** GOTO lbl73
                    block20: do {
                        block35: {
                            block36: {
                                line = line.trim();
                                lineUppercase = line.toUpperCase(Locale.ENGLISH);
                                if (!insideCFlags) break block35;
                                if (!lineUppercase.startsWith("-DCPU_")) break block36;
                                endIndex = line.lastIndexOf(" \\");
                                symbol = line.substring(6, endIndex > 1 ? endIndex : line.length());
                                if (symbol.endsWith("=1")) {
                                    symbol = symbol.substring(0, symbol.length() - 2);
                                }
                                this.setDetectedPartNumberFromSymbol(symbol);
                                ** GOTO lbl73
                            }
                            if (!lineUppercase.startsWith("-MCPU=")) ** GOTO lbl73
                            endIndex = line.lastIndexOf(" \\");
                            var12_14 = coreType = line.substring(6, endIndex > 1 ? endIndex : line.length());
                            tmp = -1;
                            switch (var12_14.hashCode()) {
                                case -1347009375: {
                                    if (var12_14.equals("cortex-m33")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case -1151830573: {
                                    if (var12_14.equals("cortex-m4")) {
                                        tmp = 2;
                                    }
                                    break;
                                }
                                case -1151830570: {
                                    if (var12_14.equals("cortex-m7")) {
                                        tmp = 3;
                                    }
                                    break;
                                }
                                case -877689879: {
                                    if (var12_14.equals("cortex-m0plus")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case 1264647926: {
                                    if (var12_14.equals("cortex-m33+nodsp")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 2: {
                                    if (!this.detectProcessorCore("cm4", new AtomicBoolean(false))) {
                                        this.detectProcessorCore("m4", new AtomicBoolean(false));
                                    }
                                    ** GOTO lbl73
                                }
                                case 3: {
                                    if (!this.detectProcessorCore("cm7", new AtomicBoolean(false))) {
                                        this.detectProcessorCore("m7", new AtomicBoolean(false));
                                    }
                                    ** GOTO lbl73
                                }
                                default: {
                                    ArmGccModernFormatPrjAdapter.LOGGER.severe(String.format("[TOOL] Unsupported ARMCC core type: %s", new Object[]{coreType}));
                                    ** GOTO lbl73
                                }
                                case 1: {
                                    if (succesfulParse.getAsBoolean()) break block20;
                                }
                            }
                        }
                        insideCFlags = lineUppercase.startsWith("SET(CMAKE_C_FLAGS_");
lbl73:
                        // 7 sources

                        if (succesfulParse.getAsBoolean()) break;
                    } while ((line = reader.readLine()) != null);
                    monitor.worked(1);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable var5_7) {
                if (var4_4 == null) {
                    var4_4 = var5_7;
                } else if (var4_4 != var5_7) {
                    var4_4.addSuppressed(var5_7);
                }
                throw var4_4;
            }
        }
        catch (FileNotFoundException v0) {
            if (!ArmGccModernFormatPrjAdapter.$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (IOException v1) {}
        this.handleUndetectedCore();
        return succesfulParse.getAsBoolean();
    }

    private /* synthetic */ boolean lambda$3() {
        return this.detectedProcessor != null && this.detectedCore != null;
    }

    static class MacroPathResolver {
        private static final Pattern MACRO_PATTER = Pattern.compile("\\$\\{([^}]+)\\}");
        private static final String CURRENT_SOURCE_DIR_MACRO = "CMAKE_CURRENT_SOURCE_DIR";
        private static final String CURRENT_LIST_DIR_MACRO = "CMAKE_CURRENT_LIST_DIR";
        private Path basePath;
        CollectionMap<@NonNull String, @NonNull Path> macroMap = new CollectionMap();

        public MacroPathResolver(File file, Path basePath) {
            this.basePath = basePath;
            File folder = file.getParentFile();
            assert (folder != null);
            this.macroMap.add((Object)CURRENT_LIST_DIR_MACRO, (Object)basePath.relativize(folder.toPath()));
            this.macroMap.add((Object)CURRENT_SOURCE_DIR_MACRO, (Object)basePath.relativize(basePath));
        }

        public @Nullable Collection<@NonNull Path> getSingleLinePath(String line) {
            if (line.endsWith(")")) {
                if (line.startsWith(")")) {
                    return null;
                }
                line = line.substring(0, line.length() - 1);
            }
            return this.getMultiLinePath(line);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable Collection<@NonNull Path> getMultiLinePath(String line) {
            Matcher macroMatch;
            if (line.startsWith(")") || line.endsWith(")")) {
                return null;
            }
            if (line.startsWith("#")) {
                return Collections.emptyList();
            }
            String srcFilePath = UtilsFile.toEclipsePath((String)line);
            if (srcFilePath.startsWith("\"") && srcFilePath.endsWith("\"")) {
                srcFilePath = srcFilePath.substring(1, srcFilePath.length() - 1);
            }
            if ((macroMatch = MACRO_PATTER.matcher(srcFilePath)).find()) {
                String macro = macroMatch.group(1);
                assert (macro != null);
                @NonNull Collection macroReplace = this.macroMap.get((Object)macro);
                if (macroReplace != null) {
                    String restPath = srcFilePath.substring(macroMatch.end());
                    if (macroReplace.size() == 1 && !restPath.isEmpty()) {
                        Path replacedPath = ((Path)CollectionsUtils.first((Collection)macroReplace)).resolve(restPath.startsWith("/") ? restPath.substring(1) : restPath);
                        return Arrays.asList(replacedPath.normalize());
                    }
                    assert (restPath.isEmpty()) : "Unsupported macro path replacments for path:" + srcFilePath;
                    return macroReplace;
                }
                LOGGER.log(macro.startsWith("CMAKE_") ? Level.INFO : Level.SEVERE, "Try to replace notdefined macros in path: {0}", macro);
            }
            try {
                return Arrays.asList(Paths.get(srcFilePath, new String[0]).normalize());
            }
            catch (InvalidPathException e) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
                return null;
            }
        }

        public @Nullable Collection<@NonNull Path> addMacroDefinition(String line) {
            String[] macroSplit = line.split(" ");
            String macroName = macroSplit[0];
            assert (macroName != null);
            Collection macroPathSet = null;
            if (line.endsWith(")")) {
                if (macroSplit.length > 1) {
                    String value = macroSplit[1];
                    assert (value != null);
                    Collection<@NonNull Path> path = this.getSingleLinePath(value);
                    if (path != null) {
                        Collection res = (Collection)this.macroMap.putIfAbsent((Object)macroName, path);
                        assert ("SdkRootDirPath".equals(macroName) || res == null) : "Try to overide macro:" + macroName;
                    }
                }
            } else {
                Collection macroPaths;
                assert (!this.macroMap.containsKey((Object)macroName)) : "Overwrite macro:" + macroName;
                macroPathSet = macroPaths = (Collection)this.macroMap.computeIfAbsent((Object)macroName, k -> new HashSet());
            }
            return macroPathSet;
        }

        public void addAllMacros(MacroPathResolver otherMacroPathResolver) {
            this.macroMap.addAll(otherMacroPathResolver.macroMap);
        }

        public Path resolveRelativePath(Path relativizePath) {
            return this.basePath.resolve(relativizePath);
        }
    }
}

