/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.validation;

import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import java.io.File;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class CommonFieldValidator
implements IValidator<String> {
    private static final String WIN32_EXECUTABLE = ".exe";
    protected String parameterName;
    private boolean isFile;
    private boolean isExecutable;

    protected CommonFieldValidator() {
    }

    public CommonFieldValidator(String parameterName) {
        this.parameterName = parameterName;
        this.isFile = false;
        this.isExecutable = false;
    }

    public CommonFieldValidator(String parameterName, boolean isFileExecutable) {
        this.parameterName = parameterName;
        this.isFile = true;
        this.isExecutable = isFileExecutable;
    }

    protected Status checkEmptiness(String name) {
        if (name.isEmpty()) {
            return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FieldValidator_empty_field, (Object)this.parameterName));
        }
        return new Status(0, "com.nxp.s32ds.debug.ide.validation", "");
    }

    public IStatus validate(String valueStr) {
        Status status = this.checkEmptiness(valueStr);
        if (this.isFile && status.isOK()) {
            try {
                File file;
                String path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(valueStr);
                if (this.isExecutable && "win32".equals(Platform.getOS()) && !path.endsWith(WIN32_EXECUTABLE)) {
                    path = path.concat(WIN32_EXECUTABLE);
                }
                if (!(file = new Path(path).toFile()).exists()) {
                    return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FileExistenceValidator_file_does_not_exist, (Object)valueStr));
                }
                if (!file.isFile()) {
                    return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FileExistenceValidator_is_not_a_file, (Object)valueStr));
                }
            }
            catch (CoreException coreException) {
                return new Status(4, "com.nxp.s32ds.debug.ide.validation", NLS.bind((String)ErrorMessages.FileExistenceValidator_file_does_not_exist, (Object)valueStr));
            }
            return new Status(0, "com.nxp.s32ds.debug.ide.validation", "");
        }
        return status;
    }
}

