/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.commanderview.view;

import com.freescale.s32ds.cdt.core.internal.commanderview.view.CommandManager;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.Messages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class CustomizationDialog
extends TitleAreaDialog {
    private CommandManager fCmdMgr = CommandManager.getInstance();
    private Set<String> fVisibleCmds = new HashSet<String>();
    private CheckboxTreeViewer fViewer;

    public CustomizationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        CommandManager.Group[] groupArray = this.fCmdMgr.getGroups();
        int n = groupArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandManager.Group group = groupArray[n2];
            this.cmdsToModel(group.children, false);
            ++n2;
        }
    }

    private void cmdsToModel(CommandManager.Command[] cmds, boolean useDefaultVisibility) {
        CommandManager.Command[] commandArray = cmds;
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            CommandManager.Command cmd = commandArray[n2];
            if (useDefaultVisibility) {
                if (cmd.visibleByDefault) {
                    this.fVisibleCmds.add(cmd.id);
                }
            } else if (this.fCmdMgr.isVisible(cmd)) {
                this.fVisibleCmds.add(cmd.id);
            }
            this.cmdsToModel(cmd.children, useDefaultVisibility);
            ++n2;
        }
    }

    private void modelToCommands(CommandManager.Command[] cmds) {
        CommandManager.Command[] commandArray = cmds;
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            CommandManager.Command cmd = commandArray[n2];
            this.fCmdMgr.setVisible(cmd, this.fVisibleCmds.contains(cmd.id));
            this.modelToCommands(cmd.children);
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)gridData);
        comp.setLayout((Layout)new GridLayout());
        this.fViewer = new CheckboxTreeViewer(comp);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(cell.getElement().toString());
            }

            public String getToolTipText(Object element) {
                if (element instanceof CommandManager.Command) {
                    return this.wrap(((CommandManager.Command)element).description, 80);
                }
                return null;
            }

            private String wrap(String text, int length) {
                StringBuilder wrapped = new StringBuilder();
                while (text.length() > 0) {
                    if (text.length() <= length) {
                        wrapped.append(text);
                        break;
                    }
                    int pos = text.substring(0, length).indexOf(10);
                    if (pos != -1) {
                        wrapped.append(text.substring(0, pos + 1));
                        text = text.substring(pos + 2);
                        continue;
                    }
                    pos = length - 1;
                    while (pos >= 0) {
                        if (Character.isWhitespace(text.charAt(pos))) break;
                        --pos;
                    }
                    if (pos == -1) {
                        wrapped.append(text.substring(0, length)).append('\n');
                        text = text.substring(length);
                        continue;
                    }
                    wrapped.append(text.substring(0, pos)).append('\n');
                    text = text.substring(pos + 1);
                }
                return wrapped.toString();
            }
        });
        this.fViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof CommandManager.Base) {
                    return ((CommandManager.Base)element).children.length > 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof CommandManager) {
                    return ((CommandManager)inputElement).getGroups();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof CommandManager.Base) {
                    return ((CommandManager.Base)parentElement).children;
                }
                return null;
            }
        });
        this.fViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                if (element instanceof CommandManager.Base) {
                    MutableInt visible = new MutableInt();
                    MutableInt hidden = new MutableInt();
                    this.getChildrenVisibleCount(((CommandManager.Base)element).children, visible, hidden);
                    return visible.value > 0 && hidden.value > 0;
                }
                return false;
            }

            private void getChildrenVisibleCount(CommandManager.Command[] commands, MutableInt visible, MutableInt hidden) {
                CommandManager.Command[] commandArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    CommandManager.Command command = commandArray[n2];
                    if (CustomizationDialog.this.fVisibleCmds.contains(command.id)) {
                        ++visible.value;
                    } else {
                        ++hidden.value;
                    }
                    this.getChildrenVisibleCount(command.children, visible, hidden);
                    ++n2;
                }
            }

            public boolean isChecked(Object element) {
                if (element instanceof CommandManager.Group) {
                    CommandManager.Group group = (CommandManager.Group)element;
                    return this.hasVisibleCommands(group.children);
                }
                if (element instanceof CommandManager.Command) {
                    return CustomizationDialog.this.fVisibleCmds.contains(((CommandManager.Command)element).id);
                }
                return false;
            }

            private boolean hasVisibleCommands(CommandManager.Command[] cmds) {
                CommandManager.Command[] commandArray = cmds;
                int n = cmds.length;
                int n2 = 0;
                while (n2 < n) {
                    CommandManager.Command cmd = commandArray[n2];
                    if (CustomizationDialog.this.fVisibleCmds.contains(cmd.id) || this.hasVisibleCommands(cmd.children)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            class MutableInt {
                int value;

                MutableInt() {
                }
            }
        });
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof CommandManager.Base) {
                    CommandManager.Base base = (CommandManager.Base)element;
                    if (event.getChecked()) {
                        CustomizationDialog.this.fVisibleCmds.add(base.id);
                    } else {
                        CustomizationDialog.this.fVisibleCmds.remove(base.id);
                    }
                    this.showCmdsRecursively(base.children, event.getChecked());
                    if (base.parent != null) {
                        CustomizationDialog.this.fVisibleCmds.add(base.parent.id);
                    }
                }
                CustomizationDialog.this.fViewer.refresh();
            }

            private void showCmdsRecursively(CommandManager.Command[] commands, boolean visible) {
                CommandManager.Command[] commandArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    CommandManager.Command command = commandArray[n2];
                    if (visible) {
                        CustomizationDialog.this.fVisibleCmds.add(command.id);
                    } else {
                        CustomizationDialog.this.fVisibleCmds.remove(command.id);
                    }
                    this.showCmdsRecursively(command.children, visible);
                    ++n2;
                }
            }
        });
        this.fViewer.setInput((Object)this.fCmdMgr);
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fViewer, (int)2);
        Button button = new Button(comp, 8);
        button.setText(Messages.CustomizeViewHandler_0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationDialog.this.fVisibleCmds.clear();
                CommandManager.Group[] groupArray = CustomizationDialog.this.fCmdMgr.getGroups();
                int n = groupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CommandManager.Group group = groupArray[n2];
                    CustomizationDialog.this.cmdsToModel(group.children, true);
                    ++n2;
                }
                CustomizationDialog.this.fViewer.refresh();
            }
        });
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
        CommandManager.Group[] groupArray = this.fCmdMgr.getGroups();
        int n = groupArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandManager.Group group = groupArray[n2];
            this.modelToCommands(group.children);
            ++n2;
        }
    }
}

