/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.readers;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIDataReadMemoryBytes;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryBytesInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;

public class MemoryReader {
    private final int READ_TIMEOUT_MS = 2000;
    private IRunControl.IExecutionDMContext context;

    public synchronized List<Integer> getMemoryBlock(long address, long length) throws DebugException {
        MemoryByte[] bytes;
        long addressAligned = address & 0xFFFFFFFFFFFFFFFCL;
        long lengthAligned = length;
        if ((length & 3L) > 0L) {
            lengthAligned = (length & 0xFFFFFFFFFFFFFFFCL) + 4L;
        }
        if ((bytes = this.readBytes(addressAligned, lengthAligned)) != null && bytes.length > 0) {
            LinkedList<Integer> memory = new LinkedList<Integer>();
            MemoryByte[] memoryByteArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte mByte = memoryByteArray[n2];
                memory.add(this.convertToUnsigned(mByte.getValue()));
                ++n2;
            }
            return memory;
        }
        Logger.error(String.format(Texts.get("Error.CouldNotGetMemoryBlock"), address, length));
        return null;
    }

    public synchronized List<Long> getMemoryBlock(long address, long length, int bytes) throws DebugException {
        List<Integer> block = this.getMemoryBlock(address, length);
        if (block != null && block.size() % 2 == 0) {
            LinkedList<Long> list = new LinkedList<Long>();
            int i = 0;
            while (i < block.size() / bytes) {
                int addr = i * bytes;
                long item = 0L;
                int j = 0;
                while (j < bytes) {
                    item += (long)block.get(addr + j).intValue() * (long)(j != 0 ? 256 * j : 1);
                    ++j;
                }
                list.add(item);
                ++i;
            }
            return list;
        }
        return null;
    }

    public synchronized List<Integer> readMemoryUntilZero(long address) throws DebugException {
        LinkedList<Integer> memory = new LinkedList<Integer>();
        boolean go = true;
        int counter = 0;
        while (go) {
            MemoryByte[] bytes = this.readBytes(address + (long)(counter * 32), 32L);
            if (bytes == null) break;
            MemoryByte[] memoryByteArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryByte b = memoryByteArray[n2];
                int value = this.convertToUnsigned(b.getValue());
                if (value == 0) {
                    go = false;
                    break;
                }
                memory.add(value);
                ++n2;
            }
            ++counter;
        }
        return memory;
    }

    private MemoryByte[] readBytes(long address, long length) {
        DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), this.getContext().getSessionId());
        IStack stack = (IStack)tracker.getService(IStack.class);
        MIDataReadMemoryBytes mi = new MIDataReadMemoryBytes((IDMContext)this.getContext(), "0x" + Long.toString(address, 16), 0L, (int)length);
        final CountDownLatch gate = new CountDownLatch(1);
        final List list = Collections.synchronizedList(new ArrayList());
        DataRequestMonitor<MIDataReadMemoryBytesInfo> rm = new DataRequestMonitor<MIDataReadMemoryBytesInfo>((Executor)stack.getExecutor(), null){

            public void handleSuccess() {
                list.add(((MIDataReadMemoryBytesInfo)this.getData()).getMIMemoryBlock());
                gate.countDown();
            }

            protected void handleError() {
                super.handleError();
            }
        };
        ICommandControl cc = (ICommandControl)tracker.getService(ICommandControl.class);
        cc.queueCommand((ICommand)mi, (DataRequestMonitor)rm);
        try {
            gate.await(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
        if (list.isEmpty()) {
            Logger.error(Texts.get("Error.ReadBytesTimout"));
            return null;
        }
        return (MemoryByte[])list.get(0);
    }

    private int convertToUnsigned(int i) {
        return i < 0 ? i & 0xFF : i;
    }

    private IRunControl.IExecutionDMContext getContext() {
        return this.context;
    }

    public void setContext(IRunControl.IExecutionDMContext context) {
        this.context = context;
    }
}

