/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.action;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SaveToClipboard
extends Action {
    private Shell parentShell;
    private TreeViewer viewer;

    public SaveToClipboard(Shell parentShell, TreeViewer viewer) {
        this.parentShell = parentShell;
        this.viewer = viewer;
    }

    public void run() {
        String tadItemStr;
        Clipboard clipboard = new Clipboard(this.parentShell.getDisplay());
        TreeItem[] selected = this.viewer.getTree().getSelection();
        if (clipboard != null && selected.length > 0 && selected[0].getData() instanceof TadItem && (tadItemStr = ((TadItem)selected[0].getData()).toString(Separator.TAB)) != null && !tadItemStr.isEmpty()) {
            try {
                clipboard.setContents(new Object[]{tadItemStr}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (IllegalArgumentException e) {
                Logger.exception(e);
            }
        }
        clipboard.dispose();
    }

    public String getText() {
        return Texts.get("Label.CopyLine");
    }

    public String getToolTipText() {
        return Texts.get("Label.CopyLine");
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
    }
}

