/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.heapusage;

import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapBlock;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapRegion;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import com.nxp.freertos.gdb.tad.view.views.heapusage.HeapBlockItem;
import java.util.LinkedList;
import java.util.List;

public class Heap5TreeChildItem
extends TadItem {
    private HeapRegion region;
    private List<HeapBlockItem> heapBlockItems;

    public Heap5TreeChildItem(int index, HeapRegion region) {
        super(index);
        this.region = region;
        int i = 0;
        this.heapBlockItems = new LinkedList<HeapBlockItem>();
        for (HeapBlock block : region.getHeapBlocks()) {
            this.heapBlockItems.add(new HeapBlockItem(block, ++i));
        }
    }

    @Override
    public List<? extends TadItem> getChildItems() {
        return this.heapBlockItems;
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.ADDRESS_START, TadColumnId.ADDRESS_END, TadColumnId.USAGE, TadColumnId.FREE_SPACE, TadColumnId.USAGE_GRAPH}, separator);
    }

    @Override
    public String getText(TadColumnId column) {
        switch (column) {
            case TYPE: {
                return String.format("#%d Reg.", this.index);
            }
            case ADDRESS_START: {
                return String.format("0x%08x", this.region.getStartAddress());
            }
            case ADDRESS_END: {
                return String.format("0x%08x", this.region.getEndAddress());
            }
            case USAGE: {
                return String.format("%s / %s", Heap5TreeChildItem.formatBytes(this.region.getUsed()), Heap5TreeChildItem.formatBytes(this.region.getSize()));
            }
            case FREE_SPACE: {
                double percentage = 100.0 - Auxiliary.getPercentage(this.region.getUsed(), this.region.getSize());
                return String.format("%.2f%% (%s)", percentage < 0.0 ? 0.0 : percentage, Heap5TreeChildItem.formatBytes(this.region.getFree() < 0L ? 0L : this.region.getFree()));
            }
            case USAGE_GRAPH: {
                return String.format("%.2f%%", Auxiliary.getPercentage(this.region.getUsed(), this.region.getSize()));
            }
        }
        return null;
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ADDRESS_START: {
                return this.region.getStartAddress();
            }
            case ADDRESS_END: {
                return this.region.getEndAddress();
            }
            case USAGE: 
            case USAGE_GRAPH: {
                return this.region.getSize();
            }
        }
        return null;
    }

    public HeapRegion getRegion() {
        return this.region;
    }
}

