/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.heapusage;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapBlock;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;

class HeapBlockItem
extends TadItem {
    private HeapBlock block;

    HeapBlockItem(HeapBlock block, int index) {
        super(index);
        this.block = block;
    }

    @Override
    public int getTextColour() {
        switch (this.block.getStatus()) {
            case FREE: {
                return 6;
            }
            case ALLOCATED: {
                if (this.block.getDetails() != null) break;
                return 16;
            }
        }
        return super.getTextColour();
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.ID, TadColumnId.DETAILS, TadColumnId.ADDRESS_START, TadColumnId.ADDRESS_END, TadColumnId.SIZE}, separator);
    }

    @Override
    public String getText(TadColumnId column) {
        try {
            switch (column) {
                case ID: {
                    return String.format("%d", this.index);
                }
                case DETAILS: {
                    return this.block.getDetails() == null ? Auxiliary.capitalize(this.block.getStatus().toString()) : this.block.getDetails();
                }
                case ADDRESS_START: {
                    return String.format("0x%08x", this.block.getStartAddress());
                }
                case ADDRESS_END: {
                    return String.format("0x%08x", this.block.getEndAddress());
                }
                case SIZE: {
                    if (this.block.getSize() == 0L) {
                        return Texts.get("Error.Empty");
                    }
                    return String.format("0x%x (%s)", this.block.getSize(), HeapBlockItem.formatBytes(this.block.getSize()));
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.exception(e, String.format(Texts.get("Exception.WhileGetTextColumn"), column.toString()));
            return null;
        }
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ADDRESS_START: {
                return this.block.getStartAddress();
            }
            case ADDRESS_END: {
                return this.block.getEndAddress();
            }
            case SIZE: {
                return this.block.getSize();
            }
        }
        return null;
    }
}

