/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.ComponentKey;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ActiveComponents
extends Components {
    private static final Logger LOGGER = LogManager.getLogger(ActiveComponents.class);
    private static final Level TRACING_LEVEL = Level.FINEST;

    public ActiveComponents() {
        super(new HashSet<ConfigurationComponentTypeId>());
    }

    public ActiveComponents(ActiveComponents original) {
        super(original, new HashSet<ConfigurationComponentTypeId>());
    }

    public ActiveComponents(Collection<ConfigurationComponentTypeId> confCompTypeIds) {
        super(new HashSet<ConfigurationComponentTypeId>(confCompTypeIds));
    }

    public ActiveComponents(CollectionMap<ComponentKey, ConfigurationComponentTypeId> map) {
        super(new HashSet<ConfigurationComponentTypeId>());
        this.componentTypeIdsMap.addAll(map);
    }

    public void removeConfigurationComponent(IConfigurationComponent oldConfigurationComponent) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            CollectionMap toRemove = new CollectionMap();
            for (Map.Entry entry : this.componentTypeIdsMap.entrySet()) {
                for (ConfigurationComponentTypeId val : (Collection)entry.getValue()) {
                    if (!val.getConfigurationComponent().equals(oldConfigurationComponent)) continue;
                    toRemove.add((Object)((ComponentKey)entry.getKey()), (Object)val);
                }
            }
            this.componentTypeIdsMap.removeAllItems(toRemove);
            return;
        }
        Iterator it = this.confCompTypeIds.iterator();
        while (it.hasNext()) {
            ConfigurationComponentTypeId typeId = (ConfigurationComponentTypeId)it.next();
            if (typeId.getConfigurationComponent() != oldConfigurationComponent) continue;
            it.remove();
            break;
        }
    }

    public @Nullable IConfigurationComponent getConfigComp(String type) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            Collection collection = this.componentTypeIdsMap.get((Object)ComponentKey.type(type));
            if (collection == null) {
                return null;
            }
            if (collection.isEmpty()) {
                return null;
            }
            return ((ConfigurationComponentTypeId)CollectionsUtils.get((Iterable)collection, (int)0)).getConfigurationComponent();
        }
        return (IConfigurationComponent)CollectionsUtils.nullableOptionalGet(this.confCompTypeIds.stream().map(y -> y.getConfigurationComponent()).filter(x -> x.getId().equals(type)).findFirst());
    }

    public @Nullable ConfigurationComponentTypeId getConfigCompTypeId(StoragePeriphsComponent storage) {
        ConfigurationComponentTypeId configCompTypeId = this.getConfigCompTypeId(storage.getTypeId());
        if (configCompTypeId == null && (configCompTypeId = this.getComponentTypeIdByType(storage.getName())) != null) {
            ConfigurationComponentTypeId configCompTypeIdFinal = configCompTypeId;
            LOGGER.log(Level.WARNING, () -> MessageFormat.format("[DATA] Component with type_id \"{0}\" is not active. Using component with type_id \"{1}\"", storage.getTypeId(), configCompTypeIdFinal.getTypeId()));
        }
        return configCompTypeId;
    }

    public @Nullable ConfigurationComponentTypeId getComponentTypeIdByType(String type) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            Collection collection = this.componentTypeIdsMap.get((Object)ComponentKey.type(type));
            if (collection == null) {
                LOGGER.log(TRACING_LEVEL, "Active components does not contain any component of type \"{0}\"", type);
                return null;
            }
            if (collection.size() != 1) {
                LOGGER.log(TRACING_LEVEL, () -> MessageFormat.format("Active components does contain multiple components of type \"{0}\": {1}", type, collection));
                return null;
            }
            return (ConfigurationComponentTypeId)CollectionsUtils.get((Iterable)collection, (int)0);
        }
        List matchingComponents = this.confCompTypeIds.stream().filter(x -> x.getType().equals(type)).collect(Collectors.toList());
        if (matchingComponents.size() != 1) {
            return null;
        }
        return (ConfigurationComponentTypeId)matchingComponents.get(0);
    }
}

