/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.EmptyContext;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.version.VersionUtils;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.ComponentKey;
import com.nxp.swtools.periphs.model.data.ComponentsProvider;
import com.nxp.swtools.periphs.model.data.ComputeScoreWrapper;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.MigrationComponent;
import com.nxp.swtools.resourcetables.model.data.Migrations;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.osgi.framework.Version;

public class Components {
    private static final Logger LOGGER = LogManager.getLogger(Components.class);
    public static final BigInteger MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS = BigInteger.valueOf(1000L);
    public static final BigInteger MULTIPLY_FACTOR_VERSION_HIGHER_THAN_REQUIRED = BigInteger.valueOf(1000000000L);
    protected Collection<ConfigurationComponentTypeId> confCompTypeIds;
    protected CollectionMap<ComponentKey, ConfigurationComponentTypeId> componentTypeIdsMap = new CollectionMap();
    private static IContext emptyContext = EmptyContext.getInstsance();
    public static final BigInteger SCORE_PERFECT_MATCH = BigInteger.valueOf(1000000L);
    public static final BigInteger SCORE_NOT_REQUIRED_NOT_MATCHING = BigInteger.valueOf(1000000L);
    public static final String COMPONENT_TYPE_USED_FOR_MARKING_AS_USED = "custom_init";

    public Components(Collection<ConfigurationComponentTypeId> confCompTypeIds) {
        this.confCompTypeIds = confCompTypeIds;
    }

    public Components(Components original, Collection<ConfigurationComponentTypeId> collection) {
        this.confCompTypeIds = collection;
        this.confCompTypeIds.clear();
        this.confCompTypeIds.addAll(original.confCompTypeIds);
    }

    public boolean addConfigurationComponent(IComponentConfig componentConfig) {
        this.componentTypeIdsMap.addAll(ComponentsProvider.getAllComponentEntries(componentConfig.getConfigCompTypeId()));
        return this.confCompTypeIds.add(componentConfig.getConfigCompTypeId());
    }

    public static @Nullable BigInteger computeMatchScore(SWComponent swComp, SupportedSdkComponent sdkComp) {
        SWComponent.Match match = swComp.getMatch();
        BigInteger score = Components.computeMatchScore(ComputeScoreWrapper.from(swComp), ComputeScoreWrapper.from(sdkComp), match != null ? match.getName() : "", swComp.getUntilVersion());
        if (score == null && !swComp.getRequired()) {
            return BigInteger.ZERO;
        }
        return score;
    }

    public static @Nullable BigInteger computeMatchScore(SWComponent current, SWComponent required) {
        SWComponent.Match match = current.getMatch();
        BigInteger score = Components.computeMatchScore(ComputeScoreWrapper.from(current), ComputeScoreWrapper.from(required), match != null ? match.getName() : "", current.getUntilVersion());
        if (score == null && !current.getRequired()) {
            return BigInteger.ZERO;
        }
        return score;
    }

    public static @Nullable BigInteger computeMatchScore(@Nullable Version swCompVersion, Version sdkCompVersion, String matchName, @Nullable Version upperLimitVersion) {
        if (swCompVersion == null) {
            return null;
        }
        return Components.computeMatchScore(ComputeScoreWrapper.from(swCompVersion), ComputeScoreWrapper.from(sdkCompVersion), matchName, upperLimitVersion);
    }

    public static @Nullable BigInteger computeMatchScore(ComputeScoreWrapper swCompVersionWrapper, ComputeScoreWrapper sdkCompVersionWrapper, String matchName, @Nullable Version upperLimitVersion) {
        Version swCompVersion = swCompVersionWrapper.getVersion();
        if (swCompVersion == null) {
            return null;
        }
        Version sdkVersion = sdkCompVersionWrapper.getVersion();
        if (sdkVersion == null) {
            return null;
        }
        Collection<String> swCompRevisions = swCompVersionWrapper.getRevisions();
        Collection<String> sdkCompRevisions = sdkCompVersionWrapper.getRevisions();
        if (!swCompRevisions.isEmpty() && CollectionsUtils.intersection(sdkCompRevisions, swCompRevisions).isEmpty()) {
            return null;
        }
        BigInteger score = null;
        SWComponent.Match match = SWComponent.Match.getMatchByName((String)matchName);
        if (match != null) {
            switch (match) {
                case PERFECT: {
                    score = Components.computeMatchScorePerfect(swCompVersion, sdkVersion);
                    break;
                }
                case COMPATIBLE: {
                    score = Components.computeMatchScoreCompatible(swCompVersion, sdkVersion, upperLimitVersion);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    score = Components.computeMatchScoreGreaterOrEqual(swCompVersion, sdkVersion, upperLimitVersion);
                    break;
                }
                default: {
                    score = Components.computeMatchScoreEquivalent(swCompVersion, sdkVersion, upperLimitVersion);
                    break;
                }
            }
        } else {
            score = Components.computeMatchScoreEquivalent(swCompVersion, sdkVersion, upperLimitVersion);
        }
        return score;
    }

    public static @Nullable BigInteger computeMatchScorePerfect(Version versionRequired, Version versionActual) {
        if (VersionUtils.perfect((Version)versionActual, (Version)versionRequired)) {
            return SCORE_PERFECT_MATCH;
        }
        return null;
    }

    public static @Nullable BigInteger computeMatchScoreEquivalent(Version versionRequired, Version versionActual, @Nullable Version upperVersionLimit) {
        if (upperVersionLimit != null && !VersionUtils.isInRange((Version)versionActual, (Version)versionRequired, (Version)upperVersionLimit)) {
            return null;
        }
        BigInteger negatedDifference = Components.computeNegatedDifferenceBetweenVersions(versionRequired, versionActual);
        if (VersionUtils.equivalent((Version)versionActual, (Version)versionRequired)) {
            return negatedDifference;
        }
        if (VersionUtils.equivalent((Version)versionRequired, (Version)versionActual)) {
            return negatedDifference.multiply(MULTIPLY_FACTOR_VERSION_HIGHER_THAN_REQUIRED);
        }
        return null;
    }

    public static @Nullable BigInteger computeMatchScoreCompatible(Version versionRequired, Version versionActual, @Nullable Version upperVersionLimit) {
        if (upperVersionLimit != null && !VersionUtils.isInRange((Version)versionActual, (Version)versionRequired, (Version)upperVersionLimit)) {
            return null;
        }
        BigInteger negatedDifference = Components.computeNegatedDifferenceBetweenVersions(versionRequired, versionActual);
        if (VersionUtils.compatible((Version)versionActual, (Version)versionRequired)) {
            return negatedDifference;
        }
        return null;
    }

    private static BigInteger computeNegatedDifferenceBetweenVersions(Version first, Version second) {
        return Components.getValueOfVersion(second).subtract(Components.getValueOfVersion(first)).abs().negate();
    }

    private static BigInteger getValueOfVersion(Version version) {
        return BigInteger.ZERO.add(BigInteger.valueOf(version.getMicro()).add(BigInteger.valueOf(version.getMinor()).multiply(MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS)).add(BigInteger.valueOf(version.getMajor()).multiply(MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS).multiply(MULTIPLY_FACTOR_VERSION_MAJOR_MINOR_DIFFERS)));
    }

    public static @Nullable BigInteger computeMatchScoreGreaterOrEqual(Version versionRequired, Version versionActual, @Nullable Version upperVersionLimit) {
        if (upperVersionLimit != null && !VersionUtils.isInRange((Version)versionActual, (Version)versionRequired, (Version)upperVersionLimit)) {
            return null;
        }
        BigInteger negatedDifference = Components.computeNegatedDifferenceBetweenVersions(versionRequired, versionActual);
        if (VersionUtils.greaterOrEqual((Version)versionActual, (Version)versionRequired)) {
            return negatedDifference;
        }
        return null;
    }

    public static @Nullable BigInteger computeMatchScore(ConfigurationComponentTypeId comp, SdkComponentsTable supportedComps) {
        BigInteger result = BigInteger.ZERO;
        for (SWComponent swComp : comp.getConfigurationComponent().getComponents()) {
            SupportedSdkComponent bestMatchingSdkComp = Components.findBestMatchingSdkComponent(swComp, supportedComps);
            if (bestMatchingSdkComp == null) {
                if (!swComp.getRequired()) continue;
                return null;
            }
            BigInteger bestMatchScore = Components.computeMatchScore(swComp, bestMatchingSdkComp);
            if (bestMatchScore == null) {
                return null;
            }
            result = result.add(bestMatchScore);
        }
        return result;
    }

    public static @Nullable SupportedSdkComponent findBestMatchingSdkComponent(SWComponent swComponent, SdkComponentsTable supportedComps) {
        SupportedSdkComponent result = (SupportedSdkComponent)CollectionsUtils.nullableOptionalGet(supportedComps.findById(swComponent.getName()).filter(sdkComp -> Components.computeMatchScore(swComponent, sdkComp) != null).max(Comparator.comparing(sdkComp -> Components.computeMatchScore(swComponent, sdkComp))));
        return result;
    }

    public @Nullable Triplet<ISetting, IConfigSet, IConfigurationComponent> findSetting(IConfigurationComponent confComp, String confSetID, String settingID, boolean autoResolve) {
        return Components.findSetting(this.getConfigComps(), confComp, confSetID, settingID, autoResolve);
    }

    public static @Nullable Triplet<ISetting, IConfigSet, IConfigurationComponent> findSetting(Collection<IConfigurationComponent> components, IConfigurationComponent confComp, String confSetID, String settingID, boolean autoResolve) {
        IConfigurationComponent comp;
        HashSet<ReferenceSetting> references = new HashSet<ReferenceSetting>();
        ISetting result = null;
        ReferenceSetting prevReference = null;
        IConfigurationComponent prevComp = comp = confComp;
        IConfigSet confSet = null;
        do {
            String refConfSetID;
            if (comp != null) {
                confSet = comp.findConfigSet(confSetID);
            }
            if (confSet != null) {
                result = confSet.find(settingID.split("\\."));
            }
            if (prevReference != null && result != null) {
                result = result.fromReference(prevReference);
                if (comp != prevComp && !result.isPublic(emptyContext)) {
                    return null;
                }
            }
            if (!(result instanceof ReferenceSetting)) continue;
            assert (comp != null);
            ReferenceSetting reference = (ReferenceSetting)result;
            if (!references.add(reference)) {
                String id = SettingUtils.buildId((String[])new String[]{comp.getId(), confSetID, settingID});
                throw new IllegalStateException("Cycle detected while finding " + id + ", composed of " + references);
            }
            String refCompID = reference.getComponentRefID();
            if (refCompID != null && !refCompID.equals(comp.getId())) {
                prevComp = comp;
                comp = (IConfigurationComponent)CollectionsUtils.nullableOptionalGet(components.stream().filter(x -> x.getId().equals(refCompID)).findFirst());
            }
            confSetID = (refConfSetID = reference.getConfigSetRefID()) == null ? confSetID : refConfSetID;
            settingID = reference.getReferenceID();
            prevReference = reference;
        } while (autoResolve && result instanceof ReferenceSetting);
        if (result == null || confSet == null || comp == null) {
            return null;
        }
        return new Triplet((Object)result, (Object)confSet, (Object)comp);
    }

    public Collection<IConfigurationComponent> getConfigComps() {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            return (Collection)this.componentTypeIdsMap.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(ccti -> ccti.getConfigurationComponent())).collect(CollectorsUtils.toList());
        }
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.confCompTypeIds.stream().map(x -> x.getConfigurationComponent()).collect(CollectorsUtils.toList())));
    }

    public @Nullable ConfigurationComponentTypeId getConfigCompTypeId(String typeId) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            Collection collection = this.componentTypeIdsMap.get((Object)ComponentKey.folder(typeId));
            if (collection == null) {
                return null;
            }
            if (collection.isEmpty()) {
                return null;
            }
            if (collection.size() != 1) {
                LOGGER.log(Level.SEVERE, "[TOOL/DATA] There are multiple component typeIds with identification {0}", typeId);
            }
            return (ConfigurationComponentTypeId)CollectionsUtils.get((Iterable)collection, (int)0);
        }
        return (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(this.confCompTypeIds.stream().filter(x -> x.getTypeId().equals(typeId)).findAny());
    }

    public @Nullable ConfigurationComponentTypeId getConfigCompTypeIdByType(String type) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            Collection collection = this.componentTypeIdsMap.get((Object)ComponentKey.type(type));
            if (collection == null) {
                return null;
            }
            if (collection.isEmpty()) {
                return null;
            }
            return (ConfigurationComponentTypeId)CollectionsUtils.get((Iterable)collection, (int)0);
        }
        return (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(this.confCompTypeIds.stream().filter(x -> x.getType().equals(type)).findAny());
    }

    public Collection<ConfigurationComponentTypeId> getConfigCompTypeIds() {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            return (Collection)this.componentTypeIdsMap.entrySet().stream().filter(entry -> ((ComponentKey)entry.getKey()).getType() == ComponentKey.KeyType.FOLDER).flatMap(entry -> ((Collection)entry.getValue()).stream()).collect(CollectorsUtils.toList());
        }
        return CollectionsUtils.unmodifiableCollection(this.confCompTypeIds);
    }

    public CollectionMap<ComponentKey, ConfigurationComponentTypeId> getComponentTypeIdsMap() {
        return this.componentTypeIdsMap;
    }

    public static @Nullable ConfigurationComponentTypeId getLatestVersionConfigCompType(List<ConfigurationComponentTypeId> configComps, ICommonMcu mcu) {
        SdkComponentsTable sdkComponentsTable = Components.getSdkComponentsTable((IMcuIdentification)mcu);
        if (configComps.isEmpty()) {
            return null;
        }
        ConfigurationComponentTypeId latestComp = configComps.get(0);
        Version highestVersion = Components.getHighestComponentVersion(latestComp);
        boolean hadRevisions = !latestComp.getComponentReferences().isEmpty() && !((SWComponent)latestComp.getComponentReferences().get(0)).getRevisionsList().isEmpty();
        for (ConfigurationComponentTypeId comp2 : configComps) {
            List newRevisions;
            Version otherVersion = Components.getHighestComponentVersion(comp2);
            List componentReferences = comp2.getComponentReferences();
            List list = newRevisions = componentReferences.isEmpty() ? Collections.emptyList() : ((SWComponent)componentReferences.get(0)).getRevisionsList();
            if (otherVersion == null || highestVersion != null && otherVersion.compareTo(highestVersion) <= 0 && (otherVersion.compareTo(highestVersion) != 0 || hadRevisions || newRevisions.isEmpty())) continue;
            latestComp = comp2;
            highestVersion = otherVersion;
            boolean bl = hadRevisions = !newRevisions.isEmpty();
        }
        if (highestVersion == null && configComps.size() > 1) {
            return null;
        }
        if (highestVersion != null && sdkComponentsTable != null) {
            Version highestVersionFinal = highestVersion;
            List componentsWithHighestVersion = (List)configComps.stream().filter(ccti -> {
                List componentReferences = ccti.getComponentReferences();
                if (componentReferences.isEmpty()) {
                    return false;
                }
                Version versionOfComponent = ((SWComponent)componentReferences.get(0)).getVersion();
                if (versionOfComponent == null) {
                    return false;
                }
                return versionOfComponent.compareTo(highestVersionFinal) == 0;
            }).collect(CollectorsUtils.toList());
            Stream sdkComponentsWithId = sdkComponentsTable.findById(((SWComponent)latestComp.getComponentReferences().get(0)).getName());
            List supportedComponents = (List)sdkComponentsWithId.collect(CollectorsUtils.toList());
            int counter = supportedComponents.size() - 1;
            while (counter >= 0) {
                SupportedSdkComponent sdkComponent = (SupportedSdkComponent)supportedComponents.get(counter);
                if (sdkComponent.getRevision() != null && (latestComp = (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(componentsWithHighestVersion.stream().filter(comp -> {
                    List componentReferences = comp.getComponentReferences();
                    if (componentReferences.isEmpty()) {
                        return false;
                    }
                    return ((SWComponent)componentReferences.get(0)).getRevisionsList().contains(sdkComponent.getRevision());
                }).findFirst())) != null) break;
                --counter;
            }
        }
        return latestComp;
    }

    public static boolean replacementMatchesAllSWComponents(List<SWComponent> currentSWComponents, List<SWComponent> replacementSWComponents) {
        for (SWComponent replacementSWComponent : replacementSWComponents) {
            SWComponent currentSWComp = (SWComponent)CollectionsUtils.nullableOptionalGet(currentSWComponents.stream().filter(swComp -> swComp.getName().equals(replacementSWComponent.getName())).findAny());
            if (currentSWComp == null) {
                return false;
            }
            BigInteger score = Components.computeMatchScore(replacementSWComponent, currentSWComp);
            if (score != null) continue;
            return false;
        }
        return true;
    }

    public static boolean canReplace(ConfigurationComponentTypeId currentComponent, ConfigurationComponentTypeId potentialReplacementComponent) {
        boolean sameType = potentialReplacementComponent.getType().equals(currentComponent.getType());
        boolean isNotDeprecated = !potentialReplacementComponent.isHidden();
        boolean isTargetOfMigration = false;
        Migrations migrations = potentialReplacementComponent.getConfigurationComponent().getMigrations();
        if (migrations != null) {
            List<MigrationComponent> migrationComponents = Components.getUsableMigrationComponents(currentComponent, migrations.getMigrationComponents());
            boolean bl = isTargetOfMigration = !migrationComponents.isEmpty();
        }
        return isNotDeprecated && (sameType || isTargetOfMigration);
    }

    public static List<MigrationComponent> getUsableMigrationComponents(ConfigurationComponentTypeId component, List<MigrationComponent> migrationComponents) {
        Predicate<MigrationComponent> typeMatchPredicate = migrationComponent -> migrationComponent.getComponentType().equals(component.getType());
        Predicate<MigrationComponent> variantMatchPredicate = migrationComponent -> migrationComponent.getVariant().equals(component.getConfigurationComponent().getVariant());
        Predicate<MigrationComponent> sdkComponentsMatchPredicate = migrationComponent -> Components.replacementMatchesAllSWComponents(component.getComponentReferences(), migrationComponent.getSwCompRefs());
        return (List)migrationComponents.stream().filter(typeMatchPredicate.and(variantMatchPredicate).and(sdkComponentsMatchPredicate)).collect(CollectorsUtils.toList());
    }

    private static @Nullable Version getHighestComponentVersion(ConfigurationComponentTypeId componentTypeId) {
        List swComps = componentTypeId.getConfigurationComponent().getComponents();
        if (swComps.isEmpty()) {
            return null;
        }
        Version highestVersion = ((SWComponent)swComps.get(0)).getVersion();
        for (SWComponent swComp : swComps) {
            Version otherVersion = swComp.getVersion();
            if (otherVersion == null || highestVersion != null && otherVersion.compareTo(highestVersion) <= 0) continue;
            highestVersion = otherVersion;
        }
        return highestVersion;
    }

    protected static @Nullable SdkComponentsTable getSdkComponentsTable(IMcuIdentification mcu) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu.getMcu(), mcu.getSdkVersion());
        return info == null ? null : derivatives.getSdkComponentsTable(info);
    }

    public void dispose() {
        this.componentTypeIdsMap.clear();
        this.confCompTypeIds.clear();
    }

    public String toString() {
        return MessageFormat.format("{0}[confCompTypeIds={1}]", this.getClass().getSimpleName(), this.confCompTypeIds);
    }
}

