/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.kex.api.IComponentReference;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Version;

public class ComputeScoreWrapper {
    private static final Logger LOGGER = LogManager.getLogger(ComputeScoreWrapper.class);
    @Nullable
    private Version version;
    private Collection<String> revisions;

    protected ComputeScoreWrapper(@Nullable Version version, Collection<String> revisions) {
        this.version = version;
        this.revisions = revisions;
    }

    public @Nullable Version getVersion() {
        return this.version;
    }

    public Collection<String> getRevisions() {
        return this.revisions;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ComputeScoreWrapper)) {
            return false;
        }
        ComputeScoreWrapper other = (ComputeScoreWrapper)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.revisions, other.revisions);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.revisions);
    }

    public String toString() {
        String revisionsString = this.getRevisions().isEmpty() ? "" : "(" + this.getRevisions() + ")";
        return this.getVersion() + revisionsString;
    }

    public static ComputeScoreWrapper from(ISdkComponentInProject projectComponent) {
        String revision = projectComponent.getRevision();
        List<String> revisionsList = Collections.emptyList();
        if (revision != null && !revision.isEmpty()) {
            revisionsList = Arrays.asList(revision);
        }
        return new ComputeScoreWrapper(projectComponent.getVersion(), revisionsList);
    }

    public static ComputeScoreWrapper from(SWComponent swComponent) {
        return new ComputeScoreWrapper(swComponent.getVersion(), swComponent.getRevisionsList());
    }

    public static ComputeScoreWrapper from(IComponentReference reference) {
        Version driverVersion = null;
        String driverVersionString = reference.getDriverVersion();
        try {
            driverVersion = Version.parseVersion((String)driverVersionString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.SEVERE, "[TOOL] Could not parse version out of string \"{0}\"", driverVersionString);
        }
        return new ComputeScoreWrapper(driverVersion, reference.getRevisions());
    }

    public static ComputeScoreWrapper from(SupportedSdkComponent sdkComponent) {
        List<String> revisionsList = Collections.emptyList();
        String revisionStr = sdkComponent.getRevision();
        if (revisionStr != null) {
            revisionsList = Arrays.asList(revisionStr);
        }
        return new ComputeScoreWrapper(sdkComponent.getVersion(), revisionsList);
    }

    public static ComputeScoreWrapper from(@Nullable Version version, Collection<String> revisions) {
        return new ComputeScoreWrapper(version, revisions);
    }

    public static ComputeScoreWrapper from(@Nullable Version version) {
        return new ComputeScoreWrapper(version, Collections.emptyList());
    }
}

