/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.AvailableResourceTables;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.InitializationPriorities;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.features.Feature;
import com.nxp.swtools.provider.features.SdkFeatures;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.McuResourceTables;
import com.nxp.swtools.resourcetables.model.mcu.ACommonMcu;
import java.text.MessageFormat;
import java.util.Collection;
import javax.script.CompiledScript;

public class Mcu
extends ACommonMcu
implements IMcu {
    private final AvailableComponents availableComponents;
    private final AvailableResourceTables availableResourceTables;
    private final SdkFeatures sdkFeatures;
    private final String partNumber;
    private final PeripheralComponentFile clockConsumers;
    @Nullable
    private ConfigurationComponentTypeId systemComponent;
    private String[] scriptFilesFolder = new String[0];
    @Nullable
    private CompiledScript compiledScript;
    @Nullable
    private Categories categories;
    @Nullable
    private InitializationPriorities initializationPriorities;

    public Mcu(AvailableComponents availableComponents, McuResourceTables mcuResourceTables, AvailableResourceTables availableResourceTables, SdkFeatures sdkFeatures, @Nullable IRegistersDatabaseAPI registersDb, IMcuIdentification mcuIdentification, IProcessorMasterToolInfo masterToolInfo, Collection<ProcessorCore> cores, PeripheralComponentFile clockConsumers, @Nullable ConfigurationComponentTypeId systemComponent, String[] scriptFileFolder, @Nullable CompiledScript compiledScript, @Nullable Categories categories, @Nullable InitializationPriorities initializationPriorities) {
        super(registersDb, mcuResourceTables, mcuIdentification, masterToolInfo, cores);
        this.availableComponents = availableComponents;
        this.availableResourceTables = availableResourceTables;
        this.sdkFeatures = sdkFeatures;
        this.partNumber = mcuIdentification.getPackage();
        this.clockConsumers = clockConsumers;
        this.systemComponent = systemComponent;
        this.scriptFilesFolder = scriptFileFolder;
        this.compiledScript = compiledScript;
        this.categories = categories;
        this.initializationPriorities = initializationPriorities;
    }

    public boolean hasFeature(String feature, @Nullable String core, @Nullable String peripheral) {
        return this.sdkFeatures.hasFeature(this.sdkFeatures.removePrefix(feature), this.partNumber, core, peripheral);
    }

    @Override
    public AvailableComponents getAvailableComponents() {
        return this.availableComponents;
    }

    @Override
    public AvailableResourceTables getAvailableResourceTables() {
        return this.availableResourceTables;
    }

    public @Nullable String getFeature(String feature, @Nullable String core, @Nullable String peripheral) {
        Feature featureFound = this.sdkFeatures.getFeatureByName(this.sdkFeatures.removePrefix(feature), this.partNumber, core, peripheral);
        return featureFound == null ? null : featureFound.getValue();
    }

    @Override
    public SdkFeatures getSdkFeatures() {
        return this.sdkFeatures;
    }

    public PeripheralComponentFile getClockConsumers() {
        return this.clockConsumers;
    }

    @Override
    public @Nullable CompiledScript getCodeGeneratorScript() {
        return this.compiledScript;
    }

    @Override
    public String[] getScriptFileFolders() {
        return this.scriptFilesFolder;
    }

    @Override
    public @Nullable Categories getCategories() {
        return this.categories;
    }

    @Override
    public @Nullable InitializationPriorities getInitializationPriorities() {
        return this.initializationPriorities;
    }

    @Override
    public @Nullable ConfigurationComponentTypeId getSystemComponent() {
        return this.systemComponent;
    }

    @Override
    public void dispose() {
        this.availableComponents.dispose();
        this.availableResourceTables.dispose();
        this.categories = null;
        this.compiledScript = null;
        this.systemComponent = null;
        this.initializationPriorities = null;
    }

    public String toString() {
        return MessageFormat.format("{0}[partNumber={1}]", this.getClass().getSimpleName(), this.partNumber);
    }
}

