/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.templates.component;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.xml.UtilsXML;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.XMLConstants;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplateProperties;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.resourcetables.model.XSDUtils;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.xml.sax.SAXException;

@Root(name="component_template", strict=false)
@Namespace(prefix="component_template", reference="http://swtools.freescale.net/XSD/component_template/1.0")
@Order(attributes={"name", "description", "type", "type_id", "original_package", "original_core"})
public class ComponentTemplate {
    public static final String EXTENSION_OF_COMPONENT_TEMPLATE = "usecase";
    public static final String FILENAME_OF_COMPONENT_TEMPLATE = "component.usecase";
    private static final Logger LOGGER = LogManager.getLogger(ComponentTemplate.class);
    private static final Persister PERSISTER = new Persister();
    private static final String LOCAL_SCHEMA = XMLConstants.COMPONENT_TEMPLATE_SCHEMA_FILENAME;
    private static final String DEFAULT_COMPONENT_TEMPLATES_FOLDER_NAME = "component_use_cases";
    private static final Pattern replaceInvalidCharactersInFolderNamePattern = Pattern.compile(" |\\.");
    private static final int FOLDERNAME_TEMPLATE_NAME_MAX_LENGTH = 20;
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation = XMLConstants.COMPONENT_TEMPLATE_SCHEMA_LOC;
    @Attribute(name="name", required=true)
    private String name = "";
    @Attribute(name="description", required=true)
    private String description = "";
    @Attribute(name="type", required=true)
    private String type = "";
    @Attribute(name="type_id", required=true)
    private String typeId = "";
    @Attribute(name="original_package", required=false)
    private String originalPackage = "";
    @Attribute(name="original_core", required=false)
    private String originalCore = "";
    @ElementList(name="sw_comp_ref", type=SWComponent.class, inline=true, required=false)
    private List<SWComponent> swCompRefs = new ArrayList<SWComponent>(1);
    @Element(name="instance", required=true)
    private StoragePeriphsComponentInstance instance = new StoragePeriphsComponentInstance();

    @Deprecated
    public ComponentTemplate() {
    }

    public ComponentTemplate(String name, String description, String type, String typeId, String originalPackage, String originalCore, StoragePeriphsComponentInstance instance, List<SWComponent> swComponents) {
        this.name = name;
        this.description = description.replaceAll("\\r\\n|\\n", "\\\\n");
        this.type = type;
        this.typeId = typeId;
        this.originalPackage = originalPackage;
        this.originalCore = originalCore;
        this.instance = instance;
        this.swCompRefs = swComponents;
    }

    public StoragePeriphsComponentInstance getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description.replaceAll("\\\\n", "\n");
    }

    public String getType() {
        return this.type;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public List<SWComponent> getSwCompRefs() {
        return this.swCompRefs;
    }

    public String getOriginalPackage() {
        return this.originalPackage;
    }

    public String getOriginalCore() {
        return this.originalCore;
    }

    public String getSchemaLocation() {
        String[] locPair = this.schemaLocation.split(" ");
        if (2 != locPair.length) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(() -> MessageFormat.format("[DATA] Component template with ID \"{0}\" specifies an invalid schema location \"{1}\"", this.name, this.schemaLocation));
            }
            return "";
        }
        String loc = locPair[1];
        return loc;
    }

    private static Path getFallbackSchemaLocation() {
        return Paths.get(Platform.isRunning() ? PEConfiguration.getSystemDirectory() : "", "resources", "schemas", LOCAL_SCHEMA);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentTemplate)) {
            return false;
        }
        ComponentTemplate other = (ComponentTemplate)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.typeId, other.typeId)) {
            return false;
        }
        if (!Objects.equals(this.originalPackage, other.originalPackage)) {
            return false;
        }
        if (!Objects.equals(this.originalCore, other.originalCore)) {
            return false;
        }
        return Objects.equals(this.instance, other.instance);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.typeId, this.description, this.originalPackage, this.originalCore, this.instance);
    }

    public String toString() {
        return MessageFormat.format("{0}[name={1}, description={2}, type={3}]", this.getClass().getSimpleName(), this.name, this.description, this.type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable ComponentTemplate loadTemplateFromFile(File file) {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (InputStream is = UtilsDecryption.getFileInputStream((File)file);){
                @Nullable ComponentTemplate template = (ComponentTemplate)PERSISTER.read(ComponentTemplate.class, is);
                if (template == null) {
                    return null;
                }
                if (!SWToolsProperties.isVerificationOn()) return template;
                try {
                    URL schema;
                    try {
                        schema = new URL(template.getSchemaLocation());
                        XSDUtils.verifySchemaVersion((URL)schema, (File)file);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.SEVERE, String.format("[DATA] Invalid schema URL in component template file \"%1s\"", file.getAbsolutePath()), e);
                        schema = null;
                    }
                    UtilsXML.validXml((InputStream)is, (URL)schema, (Path)ComponentTemplate.getFallbackSchemaLocation());
                    return template;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, String.format("[DATA] Missing schema for component template file \"%1s\"", file.getAbsolutePath()), e);
                    return template;
                }
                catch (SAXException e) {
                    LOGGER.log(Level.SEVERE, String.format("[DATA] Invalid component template file \"%1s\"", file.getAbsolutePath()), e);
                }
                return template;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Error loading component template file \"{0}\" caused by exception: {1}", file.getAbsolutePath(), cause.getLocalizedMessage()));
                return null;
            }
            LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Error loading component template file \"{0}\"", file.getAbsolutePath()), e);
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Error loading component template file \"{0}\"", file.getAbsolutePath()), e);
            return null;
        }
    }

    public static boolean saveTemplateToFile(ComponentTemplate template, File file) {
        Format format = new Format(4, "<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        try {
            serializer.write((Object)template, file);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem occurred during writing the template to file: {0}", e.getLocalizedMessage());
            return false;
        }
    }

    public static String getComponentTemplatesFolder() {
        String tmp = KEPreferences.getComponentTemplatesFolderPath();
        if (tmp == null) {
            tmp = String.valueOf(SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getDataDir()) + File.separator + DEFAULT_COMPONENT_TEMPLATES_FOLDER_NAME;
        }
        return tmp;
    }

    public static boolean createAndSaveTemplateFiles(String name, String description, String originalPackage, String originalCore, IComponentInstanceConfig instance, AvailableComponents availableComponents) {
        String typeId = instance.getComponentTypeId();
        ComponentTemplate template = new ComponentTemplate(name, description, instance.getType(), typeId, originalPackage, originalCore, instance.getStorageComponent(), instance.getComponent().getComponents());
        String folderName = ComponentTemplate.createFolderName(name, typeId);
        File componentTemplatesFolder = new File(ComponentTemplate.getComponentTemplatesFolder());
        ComponentTemplateProperties templateProperties = ComponentTemplate.createTemplateAndPropertiesFilesOnDisk(template, componentTemplatesFolder, folderName);
        if (templateProperties == null) {
            return false;
        }
        availableComponents.addTemplateProperties(templateProperties);
        return true;
    }

    public static boolean createAndSaveTemplateFiles(ComponentTemplateProperties templateProperties, File folder) {
        String folderName = ComponentTemplate.createFolderName(templateProperties.getName(), templateProperties.getTypeId());
        ComponentTemplate template = templateProperties.getTemplate();
        if (template == null) {
            return false;
        }
        ComponentTemplateProperties newProperties = ComponentTemplate.createTemplateAndPropertiesFilesOnDisk(template, folder, folderName);
        return newProperties != null;
    }

    public static boolean export(ComponentTemplateProperties properties, File folder) {
        ComponentTemplate template = properties.getTemplate();
        if (template == null) {
            return false;
        }
        return ComponentTemplate.export(template, folder);
    }

    public static boolean export(ComponentTemplate template, File folder) {
        String templateFileName = String.valueOf(ComponentTemplate.createFolderName(template.getName(), template.getTypeId())) + "." + EXTENSION_OF_COMPONENT_TEMPLATE;
        File templateFile = new File(folder, templateFileName);
        if (!ComponentTemplate.saveTemplateToFile(template, templateFile)) {
            LOGGER.log(Level.SEVERE, "Component template file was not created on the disk");
            return false;
        }
        return true;
    }

    private static @Nullable ComponentTemplateProperties createTemplateAndPropertiesFilesOnDisk(ComponentTemplate template, File templatesFolder, String folderName) {
        File templateFolder = new File(templatesFolder, folderName);
        File templateFile = new File(templateFolder, FILENAME_OF_COMPONENT_TEMPLATE);
        File propertiesFile = new File(templateFolder, "usecase.properties");
        if (!templateFolder.mkdirs()) {
            LOGGER.log(Level.SEVERE, "Folder for template was not created on the disk");
            return null;
        }
        if (!ComponentTemplate.saveTemplateToFile(template, templateFile)) {
            LOGGER.log(Level.SEVERE, "Component template file was not created on the disk");
            return null;
        }
        ComponentTemplateProperties templateProperties = ComponentTemplateProperties.createPropertiesFromTemplate(template, templateFolder.getAbsolutePath());
        if (!ComponentTemplateProperties.saveToFile(templateProperties, propertiesFile)) {
            LOGGER.log(Level.SEVERE, "Component template properties file was not created on the disk");
            return null;
        }
        return templateProperties;
    }

    private static String createFolderName(String name, String typeId) {
        String shortenedName = name;
        if (shortenedName.length() > 20) {
            shortenedName = shortenedName.substring(0, 20);
        }
        String safeName = replaceInvalidCharactersInFolderNamePattern.matcher(shortenedName).replaceAll("_");
        return String.valueOf(safeName) + "_" + typeId;
    }

    public static @Nullable ComponentTemplateProperties update(ComponentTemplateProperties oldProperties, String name, String description, AvailableComponents availableComponents) {
        ComponentTemplateProperties newProperties;
        ComponentTemplate oldTemplate = oldProperties.getTemplate();
        if (oldTemplate == null) {
            return null;
        }
        String oldFolderName = ComponentTemplate.createFolderName(oldProperties.getName(), oldProperties.getTypeId());
        File componentTemplatesFolder = new File(ComponentTemplate.getComponentTemplatesFolder());
        File oldFolder = new File(componentTemplatesFolder, oldFolderName);
        if (!oldFolder.exists()) {
            return null;
        }
        ComponentTemplate newTemplate = new ComponentTemplate(name, description, oldProperties.getType(), oldProperties.getTypeId(), oldProperties.getOriginalPackage(), oldProperties.getOriginalCore(), oldTemplate.getInstance(), oldProperties.getSwCompRefs());
        String newFolderName = ComponentTemplate.createFolderName(name, newTemplate.getTypeId());
        boolean oldFolderRemoved = false;
        if (oldFolderName.equals(newFolderName)) {
            UtilsFile.deleteDirectory((File)oldFolder);
            oldFolderRemoved = true;
        }
        if ((newProperties = ComponentTemplate.createTemplateAndPropertiesFilesOnDisk(newTemplate, componentTemplatesFolder, newFolderName)) == null) {
            return null;
        }
        if (!oldFolderRemoved) {
            UtilsFile.deleteDirectory((File)oldFolder);
        }
        availableComponents.addTemplateProperties(newProperties);
        availableComponents.removeTemplateProperties(oldProperties);
        return newProperties;
    }

    public static boolean delete(ComponentTemplateProperties properties, AvailableComponents availableComponents) {
        File componentTemplatesFolder = new File(ComponentTemplate.getComponentTemplatesFolder());
        availableComponents.removeTemplateProperties(properties);
        String folderName = ComponentTemplate.createFolderName(properties.getName(), properties.getTypeId());
        File folder = new File(componentTemplatesFolder, folderName);
        if (!folder.exists()) {
            return false;
        }
        return UtilsFile.deleteDirectory((File)folder);
    }

    public static @Nullable ComponentTemplateProperties importTemplate(ComponentTemplate template, AvailableComponents availableComponents) {
        String newFolderName;
        File componentTemplatesFolder = new File(ComponentTemplate.getComponentTemplatesFolder());
        ComponentTemplateProperties newProperties = ComponentTemplate.createTemplateAndPropertiesFilesOnDisk(template, componentTemplatesFolder, newFolderName = ComponentTemplate.createFolderName(template.getName(), template.getTypeId()));
        if (newProperties == null) {
            return null;
        }
        availableComponents.addTemplateProperties(newProperties);
        return newProperties;
    }
}

