/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.yaml;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.core.yaml.ItemConstructor;
import com.nxp.swtools.core.yaml.ItemRepresenter;
import com.nxp.swtools.periphs.model.yaml.PeriphsProfileInfo;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsArraySetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsSetSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import com.nxp.swtools.utils.scripting.FileYamlContent;
import com.nxp.swtools.utils.scripting.YamlConverter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class PeripheralsYamlConverter
extends YamlConverter<PeriphsProfileInfo, IYamlStorable> {
    private static final String END_OF_COMMENT_ESCAPED = "\\*\\/";
    private static final String END_OF_COMMENT_NOT_ESCAPED = "*/";
    private static final String START_OF_COMMENT_NOT_ESCAPED = "/*";
    private static final String START_OF_COMMENT_ESCAPED = "\\/\\*";
    @NonNull
    private static final @NonNull Map<@NonNull Class<?>, @NonNull String> CLASS_NAMES;
    @Nullable
    private static final ClassLoader CLASS_LOADER;

    static {
        CLASS_LOADER = PeriphsProfileInfo.class.getClassLoader();
        CLASS_NAMES = new HashMap();
        CLASS_NAMES.put(StoragePeriphsFuncGroup.class, "functional_group");
        CLASS_NAMES.put(StoragePeriphsArraySetting.class, "array");
        CLASS_NAMES.put(StoragePeriphsStructSetting.class, "struct");
        CLASS_NAMES.put(StoragePeriphsComponentInstance.class, "instance");
        CLASS_NAMES.put(StoragePeriphsComponent.class, "component");
        CLASS_NAMES.put(StoragePeriphsConfigSet.class, "config_set");
        CLASS_NAMES.put(StoragePeriphsScalarSetting.class, "setting");
        CLASS_NAMES.put(StoragePeriphsSetSetting.class, "set");
    }

    public PeripheralsYamlConverter() {
        super(true, CLASS_NAMES, PeriphsProfileInfo.class, IYamlStorable.class, CLASS_LOADER, "Peripherals");
        assert (CLASS_LOADER != null);
    }

    public @NonNull String createYamlFunction(@NonNull IYamlStorable yamlStorable) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.AUTO);
        dumperOptions.setWidth(160);
        Yaml yaml = new Yaml((Representer)new ItemRepresenter(), dumperOptions);
        String yamlContent = null;
        try {
            yamlContent = yaml.dump((Object)yamlStorable);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
        String tmp = this.removeBallast(UtilsText.safeString((String)yamlContent));
        tmp = tmp.replace(START_OF_COMMENT_NOT_ESCAPED, START_OF_COMMENT_ESCAPED);
        tmp = tmp.replace(END_OF_COMMENT_NOT_ESCAPED, END_OF_COMMENT_ESCAPED);
        return this.wrap(tmp);
    }

    protected Collection<String> prepareForParseYamls(Collection<String> sections) {
        ArrayList<String> result = new ArrayList<String>(sections.size());
        for (String section : sections) {
            result.add(section.replace(START_OF_COMMENT_ESCAPED, START_OF_COMMENT_NOT_ESCAPED).replace(END_OF_COMMENT_ESCAPED, END_OF_COMMENT_NOT_ESCAPED));
        }
        return result;
    }

    protected @Nullable FileYamlContent<@NonNull PeriphsProfileInfo, @NonNull IYamlStorable> processUnknownSections(@Nullable FileYamlContent<@NonNull PeriphsProfileInfo, @NonNull IYamlStorable> fileContent, List<String> unknownSections) {
        Yaml yaml = new Yaml((BaseConstructor)new ItemConstructor());
        if (fileContent != null) {
            for (String section : unknownSections) {
                try {
                    Object object = yaml.load(section);
                    if (object instanceof IYamlStorable) {
                        Collection yamlChildren = ((IYamlStorable)object).getYamlChildren();
                        if (yamlChildren == null) continue;
                        fileContent.getFunctions().addAll(yamlChildren);
                        continue;
                    }
                    LOGGER.severe(MessageFormat.format("[TOOL] Unknown section: {0}", section));
                }
                catch (Exception exception) {
                    LOGGER.severe(MessageFormat.format("[TOOL] Unknown section: {0}", section));
                }
            }
        }
        return fileContent;
    }

    protected @NonNull String removeBallast(@NonNull String text) {
        return text.replaceAll("!<([^>]+)>", "$1:");
    }
}

