/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cll;

import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;

public class CLL
implements ICLL {
    private static final boolean IS_OS_LINUX = CLL.getOSMatchesName("Linux") || CLL.getOSMatchesName("LINUX");

    public static ICLL loadCLL() throws UnsatisfiedLinkError {
        return new CLL();
    }

    private CLL() throws UnsatisfiedLinkError {
        if (IS_OS_LINUX) {
            System.loadLibrary("clljni");
        } else {
            String[] stringArray = new String[]{"FNP_Act_Installer", "cll_app_libFNP", "cll_app", "cll_svr_libFNP", "cll_svr", "FnpCommsSoap", "clljni"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                System.loadLibrary(lib);
                ++n2;
            }
        }
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    @Override
    public CLLReason installService(String productName) {
        return CLL.cllInstallService(productName);
    }

    private static native CLLReason cllInstallService(String var0);

    @Override
    public CLLReason uninstallService(String productName) {
        return CLL.cllUninstallService(productName);
    }

    private static native CLLReason cllUninstallService(String var0);

    @Override
    public CLLReason verifyLicenseAvailability(String productName, String featureName, String version) {
        return CLL.cllVerifyLicenseAvailability(productName, featureName, version);
    }

    private static native CLLReason cllVerifyLicenseAvailability(String var0, String var1, String var2);

    @Override
    public CLLReason verifyLicenseAvailabilityByFeature(String featureName, String version) {
        return CLL.cllVerifyLicenseAvailabilityByFeature(featureName, version);
    }

    private static native CLLReason cllVerifyLicenseAvailabilityByFeature(String var0, String var1);

    @Override
    public CLLFeatureDetail listActivatedFeatures(String activationID, CLLReason ppReason) {
        return CLL.cllListActivatedFeatures(activationID, ppReason);
    }

    private static native CLLFeatureDetail cllListActivatedFeatures(String var0, CLLReason var1);

    @Override
    public CLLReason loadASR(String ASRFileName) {
        return CLL.cllLoadASR(ASRFileName);
    }

    private static native CLLReason cllLoadASR(String var0);

    @Override
    public CLLReason setLicenseLocation(String directory, String serverNameOrIP, int serverPort) {
        return CLL.cllSetLicenseLocation(directory, serverNameOrIP, serverPort);
    }

    private static native CLLReason cllSetLicenseLocation(String var0, String var1, int var2);

    @Override
    public CLLReason configureProxy(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        return CLL.cllConfigureProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    private static native CLLReason cllConfigureProxy(String var0, int var1, String var2, String var3);

    @Override
    public CLLReason activateLicense(String activationID, CLLActivationType activationType, String saveFileName, Long duration, Long quantity) {
        CLLReason reason = new CLLReason();
        if (duration != null && quantity != null) {
            reason = CLL.cllActivateLicense(activationID, activationType, saveFileName, duration, quantity);
        } else {
            reason.setErrorString("Duration or quantity parameters are null.");
        }
        return reason;
    }

    private static native CLLReason cllActivateLicense(String var0, CLLActivationType var1, String var2, long var3, long var5);

    @Override
    public CLLReason processOfflineResponse(String responseFileName) {
        return CLL.cllProcessOfflineResponse(responseFileName);
    }

    private static native CLLReason cllProcessOfflineResponse(String var0);

    @Override
    public CLLReason repairLicense(String activationID, boolean bOfflineFNO, String saveFileName) {
        return CLL.cllRepairLicense(activationID, bOfflineFNO, saveFileName);
    }

    private static native CLLReason cllRepairLicense(String var0, boolean var1, String var2);

    @Override
    public CLLReason returnLicense(String activationID, boolean bOfflineFNO, String saveFileName) {
        return CLL.cllReturnLicense(activationID, bOfflineFNO, saveFileName);
    }

    private static native CLLReason cllReturnLicense(String var0, boolean var1, String var2);

    @Override
    public CLLFeatureDetail listFeatures(String productName, String featureName, String version, CLLReason ppReason) {
        return CLL.cllListFeatures(productName, featureName, version, ppReason);
    }

    private static native CLLFeatureDetail cllListFeatures(String var0, String var1, String var2, CLLReason var3);

    @Override
    public CLLReason checkoutFeature(String productName, String featureName, String version, CLLFeatureDetail ppFeatureDetail, boolean bTest) {
        return CLL.cllCheckoutFeature(productName, featureName, version, ppFeatureDetail, bTest);
    }

    private static native CLLReason cllCheckoutFeature(String var0, String var1, String var2, CLLFeatureDetail var3, boolean var4);

    @Override
    public CLLReason refreshLicense(String activationID, boolean bOfflineFNO, String saveFileName, long duration, long quantity) {
        return CLL.cllRefreshLicense(activationID, bOfflineFNO, saveFileName, duration, quantity);
    }

    private static native CLLReason cllRefreshLicense(String var0, boolean var1, String var2, long var3, long var5);

    @Override
    public void checkinFeature(String featureName) {
        CLL.cllCheckinFeature(featureName);
    }

    private static native void cllCheckinFeature(String var0);

    @Override
    public void setFNOUrlForTesting(boolean bUseTestUrl) {
        CLL.cllSetFNOUrlForTesting(bUseTestUrl);
    }

    private static native void cllSetFNOUrlForTesting(boolean var0);

    @Override
    public boolean isFnpServicePresent() {
        return CLL.cllIsFnpServicePresent();
    }

    private static native boolean cllIsFnpServicePresent();

    @Override
    public void printFlexVersion() {
        CLL.cllPrintFlexVersion();
    }

    private static native void cllPrintFlexVersion();

    @Override
    public int getVirtualStatus() {
        return CLL.cllGetVirtualStatus();
    }

    private static native int cllGetVirtualStatus();
}

