/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.core.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.cli.ISettings;
import com.nxp.s32ds.rcp.license.core.cli.cmd.AbstractCommand;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TestOffline
extends AbstractCommand {
    private static final String ACTIVATION_XML = "activation.xml";
    public static final String PARAM_ACT_ID = "actid";

    public TestOffline(ISettings settings, ICLL cll) {
        super(cll, settings);
        this.getParams().put(PARAM_ACT_ID, "Software Activation Code for product");
    }

    @Override
    public String getName() {
        return "testOffline";
    }

    @Override
    public String getOneLineDesc() {
        return "Test offline activation [debug].";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        if (this.getSettings().getParam(PARAM_ACT_ID) == null) {
            return "Software Activation Code is not set";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute() {
        try {
            super.initLicenseLocation();
            super.setupProxy();
            if (this.isTestFNO()) {
                if (this.getSettings().isDebugModeOn()) {
                    System.out.println("use test FNO");
                }
                this.getCll().setFNOUrlForTesting(true);
            }
            String actID = this.getSettings().getParam(PARAM_ACT_ID);
            CLLReason result = new CLLReason();
            System.out.print("List features: ");
            CLLFeatureDetail list = this.getCll().listFeatures(null, null, null, result);
            System.out.print(list);
            if (result.isError()) {
                System.err.println(result);
                return 1;
            }
            if (TestOffline.isContain(list, actID)) {
                System.out.print("Return " + actID + ": ");
                result = this.getCll().returnLicense(actID, false, "");
                if (result != null && result.isError()) {
                    System.err.println(result);
                    return 1;
                }
                System.out.println("Done");
            }
            String transactionId = new SimpleDateFormat("YYYY.MM.DD_HH-mm-ss").format(new Date());
            String saveFileName = "request-" + transactionId + ".xml";
            System.out.print("Generate Offline request: " + actID + ": ");
            result = this.getCll().activateLicense(actID, CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO, saveFileName, 0L, 0L);
            if (result != null && result.isError()) {
                System.err.println(result);
                return 1;
            }
            System.out.println("Done (" + saveFileName + ")");
            System.out.println("Wait for activation.xml in " + Paths.get("", new String[0]).toAbsolutePath().toString());
            while (true) {
                if (new File(ACTIVATION_XML).exists()) {
                    String responseFileName = "response-" + transactionId + ".xml";
                    Files.copy(Paths.get(ACTIVATION_XML, new String[0]), Paths.get(responseFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    System.out.print("Process response from " + responseFileName + ": ");
                    result = this.getCll().processOfflineResponse(responseFileName);
                    if (result == null || !result.isError()) break;
                    System.err.println(result);
                    return 1;
                }
                Thread.sleep(500L);
            }
            System.out.println("Done");
            System.out.println(this.getCll().listFeatures(null, null, null, result));
            if (result != null && result.isError()) {
                System.err.println(result);
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private static boolean isContain(CLLFeatureDetail list, String actID) {
        if (list == null) {
            return false;
        }
        if (actID.equals(list.getActivationID())) {
            return true;
        }
        if (list.getNext() != null) {
            return TestOffline.isContain(list.getNext(), actID);
        }
        return false;
    }
}

